/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.ChestManager;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.common.item.FuelBlockItem;
import com.teamabnormals.blueprint.common.item.InjectedBlockItem;
import com.teamabnormals.blueprint.core.api.SignManager;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockSubRegistryHelper
extends AbstractSubRegistryHelper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockSubRegistryHelper(RegistryHelper parent) {
        this(parent, parent.getSubHelper(ForgeRegistries.ITEMS).getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, ISubRegistryHelper<Item> itemHelper) {
        this(parent, itemHelper.getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> itemRegister, DeferredRegister<Block> deferredRegister) {
        super(parent, deferredRegister);
        this.itemRegister = itemRegister;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintTrappedChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, Item.Properties properties) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithItem(String name, Supplier<? extends B> supplier, Supplier<BlockItem> item) {
        this.itemRegister.register(name, item);
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createFuelBlock(String name, Supplier<? extends B> supplier, int burnTime, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().m_41491_(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createInjectedBlock(String name, Item followItem, Supplier<? extends B> supplier, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new InjectedBlockItem(followItem, (Block)block.get(), new Item.Properties().m_41491_(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithBEWLR(String name, Supplier<? extends B> supplier, Supplier<Callable<BEWLRBlockItem.LazyBEWLR>> belwr, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BEWLRBlockItem((Block)block.get(), new Item.Properties().m_41491_(group), belwr));
        return block;
    }

    public <B extends Block> RegistryObject<B> createDoubleHighBlock(String name, Supplier<? extends B> supplier, CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties().m_41491_(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createStandingAndWallBlock(String name, Supplier<? extends B> supplier, Supplier<? extends B> wallSupplier, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new StandingAndWallBlockItem((Block)block.get(), (Block)wallSupplier.get(), new Item.Properties().m_41491_(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createRareBlock(String name, Supplier<? extends B> supplier, Rarity rarity, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity).m_41491_(group)));
        return block;
    }

    public RegistryObject<BlueprintChestBlock> createChestBlock(String name, BlockBehaviour.Properties properties, @Nullable CreativeModeTab group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_chest", () -> new BlueprintChestBlock(modId + ":" + name, properties));
        ChestManager.putChestInfo(modId, name, false);
        this.itemRegister.register(name + "_chest", () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties().m_41491_(group), () -> () -> BlockSubRegistryHelper.chestBEWLR(false), 300));
        return block;
    }

    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlock(String name, BlockBehaviour.Properties properties, @Nullable CreativeModeTab group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_trapped_chest", () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", properties));
        ChestManager.putChestInfo(modId, name, true);
        this.itemRegister.register(name + "_trapped_chest", () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties().m_41491_(group), () -> () -> BlockSubRegistryHelper.chestBEWLR(true), 300));
        return block;
    }

    public Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> createSignBlock(String name, MaterialColor color) {
        WoodType type = SignManager.registerWoodType(WoodType.create((String)(this.parent.getModId() + ":" + name)));
        RegistryObject standing = this.deferredRegister.register(name + "_sign", () -> new BlueprintStandingSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), type));
        RegistryObject wall = this.deferredRegister.register(name + "_wall_sign", () -> new BlueprintWallSignBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60916_((Block)standing.get()), type));
        this.itemRegister.register(name + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(CreativeModeTab.f_40750_), (Block)standing.get(), (Block)wall.get()));
        return Pair.of((Object)standing, (Object)wall);
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String modId, String name, Supplier<? extends B> supplier, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)(BlockSubRegistryHelper.areModsLoaded(modId) ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String name, Supplier<? extends B> supplier, @Nullable CreativeModeTab group, String ... modIds) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)(BlockSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatFuelBlock(String modId, String name, Supplier<? extends B> supplier, int burnTime, @Nullable CreativeModeTab group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().m_41491_((CreativeModeTab)(BlockSubRegistryHelper.areModsLoaded(modId) ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatFuelBlock(String name, Supplier<? extends B> supplier, int burnTime, @Nullable CreativeModeTab group, String ... modIds) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().m_41491_((CreativeModeTab)(BlockSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
        return block;
    }

    public Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> createCompatChestBlocks(String compatModId, String name, MaterialColor color) {
        boolean isModLoaded = BlockSubRegistryHelper.areModsLoaded(compatModId);
        CreativeModeTab chestGroup = isModLoaded ? CreativeModeTab.f_40750_ : null;
        CreativeModeTab trappedChestGroup = isModLoaded ? CreativeModeTab.f_40751_ : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new BlueprintChestBlock(modId + ":" + name, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        this.itemRegister.register(chestName, () -> new BEWLRFuelBlockItem((Block)chest.get(), new Item.Properties().m_41491_(chestGroup), () -> () -> BlockSubRegistryHelper.chestBEWLR(false), 300));
        this.itemRegister.register(trappedChestName, () -> new BEWLRFuelBlockItem((Block)trappedChest.get(), new Item.Properties().m_41491_(trappedChestGroup), () -> () -> BlockSubRegistryHelper.chestBEWLR(true), 300));
        ChestManager.putChestInfo(modId, name, false);
        ChestManager.putChestInfo(modId, name, true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    public Pair<RegistryObject<BlueprintChestBlock>, RegistryObject<BlueprintTrappedChestBlock>> createCompatChestBlocks(String name, MaterialColor color, String ... modIds) {
        boolean isInGroup = BlockSubRegistryHelper.areModsLoaded(modIds);
        CreativeModeTab chestGroup = isInGroup ? CreativeModeTab.f_40750_ : null;
        CreativeModeTab trappedChestGroup = isInGroup ? CreativeModeTab.f_40751_ : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new BlueprintChestBlock(modId + ":" + name, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new BlueprintTrappedChestBlock(modId + ":" + name + "_trapped", BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
        this.itemRegister.register(chestName, () -> new BEWLRFuelBlockItem((Block)chest.get(), new Item.Properties().m_41491_(chestGroup), () -> () -> BlockSubRegistryHelper.chestBEWLR(false), 300));
        this.itemRegister.register(trappedChestName, () -> new BEWLRFuelBlockItem((Block)trappedChest.get(), new Item.Properties().m_41491_(trappedChestGroup), () -> () -> BlockSubRegistryHelper.chestBEWLR(true), 300));
        ChestManager.putChestInfo(modId, name, false);
        ChestManager.putChestInfo(modId, name, true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }
}

