/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public final class AdvancedRandomPos {
    @Nullable
    public static Vec3 findRandomTarget(PathfinderMob pathfinder, int xz, int y, boolean goDeep) {
        return AdvancedRandomPos.findRandomTargetBlock(pathfinder, xz, y, null, goDeep);
    }

    @Nullable
    private static Vec3 findRandomTargetBlock(PathfinderMob pathfinder, int xz, int y, @Nullable Vec3 targetVec, boolean goDeep) {
        return AdvancedRandomPos.generateRandomPos(pathfinder, xz, y, targetVec, true, 1.5707963267948966, goDeep, arg_0 -> ((PathfinderMob)pathfinder).m_21692_(arg_0));
    }

    @Nullable
    private static Vec3 generateRandomPos(PathfinderMob pathfinder, int xz, int y, @Nullable Vec3 p_191379_3_, boolean p_191379_4_, double p_191379_5_, boolean goDeep, ToDoubleFunction<BlockPos> p_191379_7_) {
        PathNavigation pathnavigator = pathfinder.m_21573_();
        RandomSource random = pathfinder.m_217043_();
        boolean flag = pathfinder.m_21536_() && pathfinder.m_21534_().m_123314_((Vec3i)pathfinder.m_20183_(), (double)(pathfinder.m_21535_() + (float)xz) + 1.0);
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = new BlockPos(pathfinder.m_20182_());
        for (int i = 0; i < 10; ++i) {
            double d1;
            BlockPos blockpos1 = AdvancedRandomPos.getBlockPos(random, xz, y, p_191379_3_, p_191379_5_, goDeep);
            if (blockpos1 == null) continue;
            int j = blockpos1.m_123341_();
            int k = blockpos1.m_123342_();
            int l = blockpos1.m_123343_();
            if (pathfinder.m_21536_() && xz > 1) {
                BlockPos blockpos2 = pathfinder.m_21534_();
                j = pathfinder.m_20185_() > (double)blockpos2.m_123341_() ? (j -= random.m_188503_(xz / 2)) : (j += random.m_188503_(xz / 2));
                l = pathfinder.m_20189_() > (double)blockpos2.m_123343_() ? (l -= random.m_188503_(xz / 2)) : (l += random.m_188503_(xz / 2));
            }
            BlockPos blockpos3 = new BlockPos((double)j + pathfinder.m_20185_(), (double)k + pathfinder.m_20186_(), (double)l + pathfinder.m_20189_());
            if (flag && !pathfinder.m_21444_(blockpos3) || !pathnavigator.m_6342_(blockpos3) || !p_191379_4_ && AdvancedRandomPos.isWaterDestination(blockpos3 = AdvancedRandomPos.moveAboveSolid(blockpos3, pathfinder), pathfinder) || !((d1 = p_191379_7_.applyAsDouble(blockpos3)) > d0)) continue;
            d0 = d1;
            blockpos = blockpos3;
            flag1 = true;
        }
        if (flag1) {
            return Vec3.m_82512_((Vec3i)blockpos);
        }
        return null;
    }

    @Nullable
    private static BlockPos getBlockPos(RandomSource rand, int xz, int y, @Nullable Vec3 Vector3d, double angle, boolean goDeep) {
        if (Vector3d != null && !(angle >= Math.PI)) {
            double d3 = Mth.m_14136_((double)Vector3d.f_82481_, (double)Vector3d.f_82479_) - 1.5707963705062866;
            double d4 = d3 + (double)(2.0f * rand.m_188501_() - 1.0f) * angle;
            double d0 = Math.sqrt(rand.m_188500_()) * (double)Mth.f_13994_ * (double)xz;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (!(Math.abs(d1) > (double)xz) && !(Math.abs(d2) > (double)xz)) {
                double newY = rand.m_188503_(2 * y + 1) - y;
                return new BlockPos(d1, newY, d2);
            }
            return null;
        }
        int newX = rand.m_188503_(2 * xz + 1) - xz;
        int newY = rand.m_188503_(2 * y + 1) - y;
        int newZ = rand.m_188503_(2 * xz + 1) - xz;
        if (goDeep) {
            newY = rand.m_188503_(y + 1) - y * 2;
        }
        return new BlockPos(newX, newY, newZ);
    }

    private static BlockPos moveAboveSolid(BlockPos pos, PathfinderMob pathfinder) {
        if (!pathfinder.f_19853_.m_8055_(pos).m_60767_().m_76333_()) {
            return pos;
        }
        BlockPos blockpos = pos.m_7494_();
        while (blockpos.m_123342_() < pathfinder.f_19853_.m_151558_() && pathfinder.f_19853_.m_8055_(blockpos).m_60767_().m_76333_()) {
            blockpos = blockpos.m_7494_();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos pos, PathfinderMob pathfinder) {
        return pathfinder.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }
}

