/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datapack;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datapack.LibXDatapack;

public class DynamicDatapackLocator
implements RepositorySource {
    private static final DynamicDatapackLocator INSTANCE = new DynamicDatapackLocator();
    private static final Set<ResourceLocation> enabledPacks = new HashSet<ResourceLocation>();

    private DynamicDatapackLocator() {
    }

    public static void locatePacks(AddPackFindersEvent event) {
        event.addRepositorySource((RepositorySource)INSTANCE);
    }

    public static synchronized void enablePack(ResourceLocation id) {
        enabledPacks.add(id);
    }

    public static synchronized boolean isEnabled(ResourceLocation id) {
        return enabledPacks.contains(id);
    }

    public void m_7686_(@Nonnull Consumer<Pack> packs, @Nonnull Pack.PackConstructor factory) {
        for (ResourceLocation id : enabledPacks) {
            String name = "libxdata/" + id.m_135827_() + ":" + id.m_135815_();
            IModFileInfo fileInfo = ModList.get().getModFileById(id.m_135827_());
            if (fileInfo == null || fileInfo.getFile() == null) {
                LibX.logger.warn("Can't create dynamic datapack " + id + ": Invalid mod file: " + fileInfo);
                continue;
            }
            Pack pack = Pack.m_10430_((String)name, (boolean)false, () -> new LibXDatapack(fileInfo.getFile(), id.m_135815_()), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (pack == null) continue;
            packs.accept(pack);
        }
    }
}

