/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.impl;

import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.moddingx.libx.annotation.impl.LazyMapBuilder;
import org.moddingx.libx.codec.MoreCodecs;
import org.moddingx.libx.config.ConfigManager;
import org.moddingx.libx.config.mapper.GenericValueMapper;
import org.moddingx.libx.config.mapper.MapperFactory;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.impl.reflect.ReflectionHacks;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.mod.ModXRegistration;
import org.moddingx.libx.registration.MultiRegisterable;

public class ProcessorInterface {
    public static ResourceLocation newRL(String rl) {
        return new ResourceLocation(rl);
    }

    public static ResourceLocation newRL(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static void registerConfig(ModX mod, String name, Class<?> configClass, boolean client) {
        ConfigManager.registerConfig(mod.resource(name), configClass, client);
    }

    public static void registerConfigMapper(ModX mod, ValueMapper<?, ?> mapper) {
        ConfigManager.registerValueMapper(mod.modid, mapper);
    }

    public static void registerConfigMapper(ModX mod, GenericValueMapper<?, ?, ?> mapper) {
        ConfigManager.registerValueMapper(mod.modid, mapper);
    }

    public static void registerConfigMapper(ModX mod, MapperFactory<?> mapper) {
        ConfigManager.registerValueMapperFactory(mod.modid, mapper);
    }

    public static void register(ModX mod, @Nullable ResourceKey<? extends Registry<?>> registryKey, String name, Object value, @Nullable FieldGetter field, boolean multi) throws ReflectiveOperationException {
        if (!(mod instanceof ModXRegistration)) {
            throw new IllegalStateException("Can't register to a non-ModXRegistration mod.");
        }
        ModXRegistration reg = (ModXRegistration)mod;
        if (multi) {
            if (!(value instanceof MultiRegisterable)) {
                throw new IllegalStateException("Can't multi-register a non-MultiRegisterable.");
            }
            MultiRegisterable multiReg = (MultiRegisterable)value;
            reg.registerMulti(registryKey, name, multiReg);
        } else {
            ForgeRegistry forgeRegistry;
            reg.register(registryKey, name, value);
            if (registryKey != null && field != null && (forgeRegistry = RegistryManager.ACTIVE.getRegistry(registryKey.m_135782_())) != null) {
                ModInternal.get(mod).getRegistrationDispatcher().notifyRegisterField((IForgeRegistry<?>)forgeRegistry, name, field.get());
            }
        }
    }

    public static void runUnchecked(ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            ReflectionHacks.throwUnchecked(e);
        }
    }

    public static <T extends Enum<T>> Codec<T> enumCodec(Class<T> clazz) {
        return MoreCodecs.enumCodec(clazz);
    }

    public static <T extends Event> void addModListener(Class<T> event, Consumer<T> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, event, listener);
    }

    public static <T extends Event> void addLowModListener(Class<T> event, Consumer<T> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, false, event, listener);
    }

    public static <T extends Event> void addForgeListener(Class<T> event, Consumer<T> listener) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, event, listener);
    }

    public static void addDataProvider(GatherDataEvent event, DataProvider provider) {
        event.getGenerator().m_236039_(true, provider);
    }

    public static DataGenerator getDataGenerator(GatherDataEvent event) {
        return event.getGenerator();
    }

    public static ExistingFileHelper getDataFileHelper(GatherDataEvent event) {
        return event.getExistingFileHelper();
    }

    public static <K, V> LazyMapBuilder<K, V> lazyMapBuilder() {
        return new LazyMapBuilder();
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static void addSpecialModel(ModelEvent.RegisterAdditional event, ResourceLocation id) {
        event.register(id);
    }

    public static BakedModel getSpecialModel(ModelEvent.BakingCompleted event, ResourceLocation id) {
        if (event.getModels().containsKey(id)) {
            return (BakedModel)event.getModels().get(id);
        }
        throw new IllegalStateException("Model not loaded: " + id);
    }

    @FunctionalInterface
    public static interface FieldGetter {
        public Field get() throws ReflectiveOperationException;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

