/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class BlockConversionRecipeCategory
implements IRecipeCategory<BlockConversionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BlockConversionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/block_conversion.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 90, 52);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42594_));
    }

    public RecipeType<BlockConversionRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BLOCK_CONVERSION_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.block_conversion");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BlockConversionRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 38, 5).addIngredients(ProductiveBeesJeiPlugin.BEE_INGREDIENT, recipe.getBees())).setSlotName("source");
        if (!recipe.input.m_43947_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 26).addItemStacks(Arrays.asList(recipe.input.m_43908_()))).setSlotName("sourceBlocks");
        } else if (recipe.stateFrom.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 25).addItemStacks(Arrays.asList(recipe.fromDisplay.m_43908_()))).setSlotName("sourceBlock");
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 26).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singletonList(new FluidStack(recipe.stateFrom.m_60819_().m_76152_(), 1000)))).setSlotName("sourceFluid");
        }
        if (recipe.stateTo.m_60819_().m_76152_().equals(Fluids.f_76191_)) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 25).addItemStacks(Arrays.asList(recipe.toDisplay.m_43908_()))).setSlotName("resultBlock");
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 26).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Collections.singletonList(new FluidStack(recipe.stateTo.m_60819_().m_76152_(), 1000)))).setSlotName("resultFluid");
        }
    }
}

