/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.recipe.TagOutputRecipe;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class AdvancedBeehiveRecipe
extends TagOutputRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> ingredient;

    public AdvancedBeehiveRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredient, Map<Ingredient, IntArrayTag> itemOutput) {
        super(itemOutput);
        this.id = id;
        this.ingredient = ingredient;
    }

    public String toString() {
        return "AdvancedBeehiveRecipe{id=" + this.id + "}";
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.ingredient.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier();
            return beeName.equals(((BeeIngredient)this.ingredient.get()).getBeeType().toString());
        }
        if (this.ingredient.get() == null) {
            ProductiveBees.LOGGER.info("bee ingredient for " + this.id + " is null");
        }
        return false;
    }

    @Override
    public Map<ItemStack, IntArrayTag> getRecipeOutputs() {
        Map<ItemStack, IntArrayTag> output = super.getRecipeOutputs();
        for (Map.Entry<ItemStack, IntArrayTag> entry : output.entrySet()) {
            if (!((BeeIngredient)this.ingredient.get()).isConfigurable() || !entry.getKey().m_41720_().equals(ModItems.CONFIGURABLE_HONEYCOMB.get())) continue;
            BeeCreator.setTag(((BeeIngredient)this.ingredient.get()).getBeeType().toString(), entry.getKey());
        }
        return output;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.ADVANCED_BEEHIVE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get();
    }

    public static class Serializer<T extends AdvancedBeehiveRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String beeName = GsonHelper.m_13906_((JsonObject)json, (String)"ingredient");
            Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
            LinkedHashMap<Ingredient, IntArrayTag> itemOutputs = new LinkedHashMap<Ingredient, IntArrayTag>();
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            jsonArray.forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String ingredientKey = jsonObject.has("item") ? "item" : "comb_produce";
                Ingredient produce = GsonHelper.m_13885_((JsonObject)jsonObject, (String)ingredientKey) ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)jsonObject, (String)ingredientKey)) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)ingredientKey));
                int min = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"min", (int)1);
                int max = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"max", (int)1);
                int outputChance = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"chance", (int)100);
                IntArrayTag nbt = new IntArrayTag(new int[]{min, max, outputChance});
                itemOutputs.put(produce, nbt);
            });
            return this.factory.create(id, (Lazy<BeeIngredient>)beeIngredient, itemOutputs);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                BeeIngredient ingredient = BeeIngredient.fromNetwork(buffer);
                LinkedHashMap<Ingredient, IntArrayTag> itemOutput = new LinkedHashMap<Ingredient, IntArrayTag>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.put(Ingredient.m_43940_((FriendlyByteBuf)buffer), new IntArrayTag(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> ingredient), itemOutput);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading beehive produce recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                if (((AdvancedBeehiveRecipe)recipe).ingredient.get() == null) {
                    throw new RuntimeException("Bee produce recipe ingredient missing " + ((AdvancedBeehiveRecipe)recipe).m_6423_() + " - " + ((AdvancedBeehiveRecipe)recipe).ingredient);
                }
                ((BeeIngredient)((AdvancedBeehiveRecipe)recipe).ingredient.get()).toNetwork(buffer);
                buffer.writeInt(((AdvancedBeehiveRecipe)recipe).itemOutput.size());
                ((AdvancedBeehiveRecipe)recipe).itemOutput.forEach((key, value) -> {
                    key.m_43923_(buffer);
                    buffer.writeInt(value.get(0).m_7047_());
                    buffer.writeInt(value.get(1).m_7047_());
                    buffer.writeInt(value.get(2).m_7047_());
                });
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing beehive produce recipe to packet. " + ((AdvancedBeehiveRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends AdvancedBeehiveRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Map<Ingredient, IntArrayTag> var3);
        }
    }
}

