/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.config.CoreClientConfig;
import cofh.core.item.ILeftClickHandlerItem;
import cofh.core.item.SickleItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxSickleItem
extends SickleItem
implements IMultiModeFluxItem,
ILeftClickHandlerItem {
    protected static final Set<Enchantment> VALID_ENCHANTS = new ObjectOpenHashSet();
    protected final float damage = this.m_41008_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxSickleItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void initEnchants() {
        VALID_ENCHANTS.add(Enchantments.f_44983_);
        VALID_ENCHANTS.add(Enchantments.f_44982_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || VALID_ENCHANTS.contains(enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluxSickleItemWrapper(stack, this);
    }

    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return target.m_20191_().m_82377_((double)this.radius + 0.25, (double)this.height + 0.25, (double)this.radius + 0.25);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        LivingEntity living;
        return this.isEmpowered(stack) && entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6162_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && !state.m_204336_(BlockTags.f_13076_)) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergy(stack, false) && (EFFECTIVE_MATERIALS.contains(state.m_60767_()) || state.m_60734_() instanceof HugeMushroomBlock);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? this.getEfficiency(stack) : 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return player.m_7500_() && (!this.isCorrectToolForDrops(stack, player.f_19853_.m_8055_(pos)) || this.isEmpowered(stack) && !AreaEffectHelper.isMature((Level)player.f_19853_, (BlockPos)pos));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public float getEfficiency(ItemStack stack) {
        return this.f_40980_;
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    public void onLeftClick(Player player, ItemStack stack) {
        float strength = player.m_36403_(0.5f);
        if (strength < 0.9f || player.m_20142_() || player.m_36341_() || !this.hasEnergy(stack, false)) {
            return;
        }
        float damage = (float)player.m_21133_(Attributes.f_22281_) * (0.2f + strength * strength * 0.8f);
        float sweep = EnchantmentHelper.m_44821_((LivingEntity)player);
        boolean empowered = this.isEmpowered(stack);
        boolean hit = false;
        for (LivingEntity target : player.f_19853_.m_45976_(LivingEntity.class, stack.getSweepHitBox(player, (Entity)player))) {
            ArmorStand stand;
            if (target == player || player.m_7307_((Entity)target) || empowered && target.m_6162_() || target instanceof ArmorStand && (stand = (ArmorStand)target).m_31677_() || !player.canHit((Entity)target, 0.0)) continue;
            hit = true;
            Vec3 disp = player.m_20182_().m_82546_(target.m_20182_());
            target.m_147240_((double)0.3f, disp.f_82479_, disp.f_82481_);
            float bonus = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()) * strength;
            target.m_6469_(DamageSource.m_19344_((Player)player), 1.0f + (damage + bonus) * sweep);
        }
        if (hit) {
            this.useEnergy(stack, false, (Entity)player);
        }
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
    }

    protected class FluxSickleItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffectItem {
        private final LazyOptional<IAreaEffectItem> holder;

        FluxSickleItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
            if (FluxSickleItem.this.hasEnergy(this.container, false)) {
                if (FluxSickleItem.this.isEmpowered(this.container)) {
                    return AreaEffectHelper.getMatureBlocksCentered((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)FluxSickleItem.this.radius, (int)FluxSickleItem.this.height);
                }
                return AreaEffectHelper.getBlocksCentered((ItemStack)this.container, (BlockPos)pos, (Player)player, (int)FluxSickleItem.this.radius, (int)FluxSickleItem.this.height);
            }
            return ImmutableList.of();
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

