/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.level.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.PrebuiltStructureProvider;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructure;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.mixin.ChunkGeneratorAccess;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class CustomChunkGenerator
extends NoiseBasedChunkGenerator
implements PrebuiltStructureProvider {
    public static final Codec<CustomChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> CustomChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.f_64318_), (App)ResourceLocation.f_135803_.fieldOf("prebuilt_structure_id").forGetter(gen -> gen.prebuiltStructureId))).apply((Applicative)instance, instance.stable(CustomChunkGenerator::new)));
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final ResourceLocation prebuiltStructureId;
    private final HolderSet<StructureSet> startStructure;

    public static CustomChunkGenerator customChunkgen(RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        MultiNoiseBiomeSource biomeSource;
        Registry structureSetRegistry = registryAccess.m_175515_(Registry.f_211073_);
        Registry biomeRegistry = registryAccess.m_175515_(Registry.f_122885_);
        if (!((String)FTBDimensionsConfig.COMMON_GENERAL.singleBiomeId.get()).isEmpty()) {
            ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation((String)FTBDimensionsConfig.COMMON_GENERAL.singleBiomeId.get()));
            biomeSource = new FixedBiomeSource(biomeRegistry.m_206081_(biomeKey));
        } else {
            biomeSource = MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(biomeRegistry);
        }
        Registry noiseRegistry = registryAccess.m_175515_(Registry.f_194568_);
        ResourceKey noiseSettingsKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)new ResourceLocation((String)FTBDimensionsConfig.COMMON_GENERAL.noiseSettings.get()));
        Holder noiseSettings = registryAccess.m_175515_(Registry.f_122878_).m_206081_(noiseSettingsKey);
        CustomChunkGenerator gen = new CustomChunkGenerator((Registry<StructureSet>)structureSetRegistry, (Registry<NormalNoise.NoiseParameters>)noiseRegistry, (BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseSettings, prebuiltStructureId);
        if (!((FTBDimensionsConfig.FeatureGeneration)((Object)FTBDimensionsConfig.COMMON_GENERAL.allowFeatureGen.get())).shouldGenerate(false)) {
            ((ChunkGeneratorAccess)((Object)gen)).setFeaturesPerStep(List::of);
        }
        return gen;
    }

    private CustomChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, ResourceLocation prebuiltStructureId) {
        super(structureSets, noises, biomeSource, settings);
        this.prebuiltStructureId = prebuiltStructureId;
        this.noises = noises;
        ResourceLocation structureSetId = PrebuiltStructureManager.getServerInstance().getStructure(prebuiltStructureId).map(PrebuiltStructure::structureSetId).orElse(PrebuiltStructure.DEFAULT_STRUCTURE_SET);
        this.startStructure = structureSets.m_203561_(TagKey.m_203882_((ResourceKey)Registry.f_211073_, (ResourceLocation)structureSetId));
    }

    @Override
    public ResourceLocation getPrebuiltStructureId() {
        return this.prebuiltStructureId;
    }

    public Stream<Holder<StructureSet>> m_207969_() {
        return Stream.concat(this.startStructure.m_203614_(), super.m_207969_());
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }
}

