/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import dev.ftb.mods.ftbteamdimensions.FTBTeamDimensions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FileUtils;

public class Pregen {
    private static final Path PREGEN_PATH = Path.of("ftbteamdimensions", "pregen");
    private static final Path PREGEN_INITIAL_PATH = Path.of("ftbteamdimensions", "pregen_initial");
    private static final List<String> INITIAL_SUBDIRS = List.of("region", "entities", "poi", "DIM1", "DIM-1");

    public static void copyIfExists(MinecraftServer server, ResourceLocation prebuiltId, ResourceKey<Level> levelKey) {
        Path rootDir = server.m_6237_().toPath();
        Path resDir = Path.of(prebuiltId.m_135827_(), prebuiltId.m_135815_().split("/"));
        Path pregenDir = rootDir.resolve(PREGEN_PATH).resolve(resDir);
        if (!pregenDir.toFile().isDirectory() || !pregenDir.resolve("region").toFile().isDirectory()) {
            return;
        }
        Path destDir = server.m_129843_(LevelResource.f_78182_).resolve("dimensions").resolve(levelKey.m_135782_().m_135827_()).resolve(levelKey.m_135782_().m_135815_());
        try {
            FileUtils.copyDirectory((File)pregenDir.toFile(), (File)destDir.toFile());
            FTBTeamDimensions.LOGGER.info("Copied pregen MCA files from {} to {}", (Object)pregenDir, (Object)destDir);
        }
        catch (IOException e) {
            FTBTeamDimensions.LOGGER.error("Failed to copy pregen MCA files from {} to {}: {}", (Object)pregenDir, (Object)destDir, (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void maybeDoInitialPregen(MinecraftServer server) {
        Path initialPath = server.m_6237_().toPath().resolve(PREGEN_INITIAL_PATH);
        Path worldPath = server.m_129843_(LevelResource.f_78182_);
        if (Files.isDirectory(initialPath, new LinkOption[0]) && !Files.isDirectory(worldPath.resolve("region"), new LinkOption[0])) {
            for (String subDir : INITIAL_SUBDIRS) {
                Path srcDir = initialPath.resolve(subDir);
                Path destDir = worldPath.resolve(subDir);
                if (!Files.isDirectory(srcDir, new LinkOption[0]) || Files.isDirectory(destDir, new LinkOption[0])) continue;
                try {
                    FileUtils.copyDirectory((File)srcDir.toFile(), (File)destDir.toFile());
                    FTBTeamDimensions.LOGGER.info("Copied initial pregen MCA files from {} to {}", (Object)srcDir, (Object)destDir);
                }
                catch (IOException e) {
                    FTBTeamDimensions.LOGGER.error("Failed to copy initial MCA files from {} to {}: {}", (Object)srcDir, (Object)destDir, (Object)e.getMessage());
                }
            }
        }
    }
}

