/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions;

import dev.ftb.mods.ftbteamdimensions.mixin.EntityAccess;
import dev.ftb.mods.ftbteamdimensions.mixin.ServerPlayerAccess;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NetherPortalPlacement {
    public static PortalInfo teamSpecificEntryPoint(ServerLevel netherLevel, ServerPlayer serverPlayer, @Nullable Team team) {
        WorldBorder worldborder = netherLevel.m_6857_();
        BlockPos pos0 = NetherPortalPlacement.getBasePos(serverPlayer, team);
        BlockPos blockpos1 = worldborder.m_187569_((double)pos0.m_123341_(), (double)pos0.m_123342_(), (double)pos0.m_123343_());
        BlockPos entrancePos = Objects.requireNonNullElseGet(((EntityAccess)serverPlayer).getPortalEntrancePos(), () -> ((ServerPlayer)serverPlayer).m_20183_());
        return ((ServerPlayerAccess)serverPlayer).invokeGetExitPortal(netherLevel, blockpos1, true, worldborder).map(foundRect -> {
            Vec3 vec3;
            Direction.Axis axis;
            BlockState blockstate = serverPlayer.f_19853_.m_8055_(entrancePos);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle rect2 = BlockUtil.m_124334_((BlockPos)entrancePos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> serverPlayer.f_19853_.m_8055_(pos) == blockstate);
                vec3 = NetherPortalPlacement.getRelativePortalPos(serverPlayer, axis, rect2);
            } else {
                axis = Direction.Axis.X;
                vec3 = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_77699_((ServerLevel)netherLevel, (BlockUtil.FoundRectangle)foundRect, (Direction.Axis)axis, (Vec3)vec3, (EntityDimensions)serverPlayer.m_6972_(serverPlayer.m_20089_()), (Vec3)serverPlayer.m_20184_(), (float)serverPlayer.m_146908_(), (float)serverPlayer.m_146909_());
        }).orElse(null);
    }

    public static PortalInfo teamSpecificEntryPoint(ServerLevel netherLevel, ServerPlayer serverPlayer) {
        return NetherPortalPlacement.teamSpecificEntryPoint(netherLevel, serverPlayer, null);
    }

    private static BlockPos getBasePos(ServerPlayer serverPlayer, @Nullable Team team) {
        UUID id = team == null ? FTBTeamsAPI.getPlayerTeamID((UUID)serverPlayer.m_20148_()) : team.getId();
        Random rand = new Random(id.getLeastSignificantBits() ^ id.getMostSignificantBits());
        double angle = rand.nextDouble(Math.PI * 2);
        int dist = rand.nextInt(25000);
        return new BlockPos(Math.cos(angle) * (double)dist, (double)serverPlayer.m_20183_().m_123342_(), Math.sin(angle) * (double)dist);
    }

    private static Vec3 getRelativePortalPos(ServerPlayer player, Direction.Axis axis, BlockUtil.FoundRectangle rect) {
        Vec3 pos = PortalShape.m_77738_((BlockUtil.FoundRectangle)rect, (Direction.Axis)axis, (Vec3)player.m_20182_(), (EntityDimensions)player.m_6972_(player.m_20089_()));
        return new Vec3(pos.f_82479_, pos.f_82480_, 0.0);
    }
}

