/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbteamdimensions.net.OpenVisitGui;
import dev.ftb.mods.ftbteamdimensions.net.VisitDimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class VisitScreen
extends Screen {
    private final Map<ResourceLocation, OpenVisitGui.DimData> dim2name;
    private VisitList visitList;
    private EditBox searchBox;
    private Button createButton;
    private boolean showArchived = true;

    public VisitScreen(Map<ResourceLocation, OpenVisitGui.DimData> dim2name) {
        super((Component)Component.m_237119_());
        this.dim2name = dim2name;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.visitList = new VisitList(this.getMinecraft(), this.f_96543_, this.f_96544_, 80, this.f_96544_ - 40);
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 80, 40, 160, 20, (Component)Component.m_237119_());
        this.searchBox.m_94151_(this.visitList::onFilterChanged);
        MutableComponent label = Component.m_237115_((String)"screens.ftbteamdimensions.show_archived");
        int lw = this.f_96547_.m_92852_((FormattedText)label) + 35;
        Checkbox checkbox = new Checkbox(this.f_96543_ - lw, 40, lw, 20, (Component)label, true){

            public void m_5691_() {
                super.m_5691_();
                VisitScreen.this.showArchived = this.m_93840_();
                VisitScreen.this.visitList.onFilterChanged(VisitScreen.this.searchBox.m_94155_());
            }
        };
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 130, this.f_96544_ - 30, 100, 20, (Component)Component.m_237115_((String)"screens.ftbteamdimensions.back"), btn -> this.m_7379_()));
        this.createButton = new Button(this.f_96543_ / 2 - 20, this.f_96544_ - 30, 150, 20, (Component)Component.m_237115_((String)"screens.ftbteamdimensions.visit"), btn -> this.onActivate());
        this.m_142416_((GuiEventListener)this.createButton);
        this.createButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)checkbox);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_7787_((GuiEventListener)this.visitList);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        this.visitList.m_6305_(matrices, mouseX, mouseY, partialTick);
        this.searchBox.m_6305_(matrices, mouseX, mouseY, partialTick);
        super.m_6305_(matrices, mouseX, mouseY, partialTick);
        String value = Component.m_237115_((String)"screens.ftbteamdimensions.select_dimension").getString();
        this.f_96547_.m_92750_(matrices, value, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(value) / 2.0f, 20.0f, 0xFFFFFF);
    }

    private void onActivate() {
        if (this.visitList.m_93511_() == null) {
            return;
        }
        new VisitDimension(((VisitList.Entry)this.visitList.m_93511_()).dim).sendToServer();
        if (this.getMinecraft().f_91073_ != null) {
            this.m_7379_();
        }
    }

    private class VisitList
    extends AbstractSelectionList<Entry> {
        public VisitList(Minecraft minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom, 50);
            this.addChildren("");
        }

        private void addChildren(String filter) {
            ArrayList entries = new ArrayList();
            VisitScreen.this.dim2name.forEach((dim, data) -> {
                if (VisitScreen.this.showArchived || !data.archived()) {
                    String name = data.teamName();
                    if (filter.isEmpty() || dim.toString().toLowerCase().contains(filter) || name.toLowerCase().contains(filter)) {
                        entries.add(new Entry((ResourceLocation)dim, (OpenVisitGui.DimData)data));
                    }
                }
            });
            this.m_6702_().addAll(entries.stream().sorted(Comparator.comparing(o -> o.data.teamName())).toList());
        }

        public int m_5759_() {
            return 400;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 200;
        }

        public void setSelected(@Nullable Entry entry) {
            VisitScreen.this.createButton.f_93623_ = entry != null;
            super.m_6987_((AbstractSelectionList.Entry)entry);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        private void onFilterChanged(String filter) {
            this.m_6702_().clear();
            this.addChildren(filter);
        }

        private class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private final ResourceLocation dim;
            private final OpenVisitGui.DimData data;
            private long lastClickTime;

            public Entry(ResourceLocation dim, OpenVisitGui.DimData data) {
                this.dim = dim;
                this.data = data;
            }

            public boolean m_6375_(double x, double y, int partialTick) {
                VisitList.this.setSelected(this);
                if (Util.m_137550_() - this.lastClickTime < 250L) {
                    VisitScreen.this.onActivate();
                    return true;
                }
                this.lastClickTime = Util.m_137550_();
                return false;
            }

            public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Font font = Minecraft.m_91087_().f_91062_;
                Objects.requireNonNull(font);
                int lh = 9 + 1;
                int tpsCol = this.data.tickTime() < 50.0 ? 0x80FF80 : (this.data.tickTime() < 100.0 ? 0xFFFF80 : 0xFF8080);
                int startX = left + 5;
                font.m_92763_(poseStack, (Component)Component.m_237113_((String)this.dim.toString()), (float)startX, (float)(top + 5), this.data.archived() ? 0x808080 : 0xFFFFFF);
                font.m_92763_(poseStack, (Component)Component.m_237113_((String)this.data.teamName()), (float)startX, (float)(top + 5 + lh), this.data.archived() ? 0x606060 : 0xD3D3D3);
                double tps = Math.min(1000.0 / this.data.tickTime(), 20.0);
                font.m_92763_(poseStack, (Component)Component.m_237113_((String)String.format("%.3f ms/tick (%.3f TPS)", this.data.tickTime(), tps)), (float)(startX + 5), (float)(top + 5 + lh * 2), tpsCol);
                if (this.data.archived()) {
                    font.m_92763_(poseStack, (Component)Component.m_237113_((String)"Archived"), (float)(startX + 5), (float)(top + 5 + lh * 3), 0xD0A000);
                } else {
                    font.m_92763_(poseStack, (Component)Component.m_237113_((String)"Active"), (float)(startX + 5), (float)(top + 5 + lh * 3), 0xD0D000);
                }
                if (isMouseOver) {
                    List<MutableComponent> tooltip = List.of(Component.m_237110_((String)"screens.ftbteamdimensions.block_entities", (Object[])new Object[]{this.data.blockEntities()}), Component.m_237110_((String)"screens.ftbteamdimensions.entities", (Object[])new Object[]{this.data.entities()}), Component.m_237110_((String)"screens.ftbteamdimensions.loaded_chunks", (Object[])new Object[]{this.data.loadedChunks()}));
                    VisitScreen.this.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, ItemStack.f_41583_);
                }
            }
        }
    }
}

