/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class CosmeticRemoveRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<CosmeticRemoveRecipe> SERIALIZER = new SimpleRecipeSerializer(CosmeticRemoveRecipe::new);

    public CosmeticRemoveRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundAttachable = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.m_41720_() instanceof CosmeticBauble) && !attachable.getCosmeticItem(stack).m_41619_()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv) {
        ItemStack attachableItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            attachableItem = stack;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)attachableItem.m_41720_();
        if (attachable.getCosmeticItem(attachableItem).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = attachableItem.m_41777_();
        copy.m_41764_(1);
        attachable.setCosmeticItem(copy, ItemStack.f_41583_);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            Item patt2650$temp = s.m_41720_();
            if (patt2650$temp instanceof BaubleItem) {
                BaubleItem bauble = (BaubleItem)patt2650$temp;
                ItemStack stack = bauble.getCosmeticItem((ItemStack)s);
                stack.m_41764_(1);
                return stack;
            }
            return null;
        });
    }
}

