/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class BuriedPetalBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = BuriedPetalBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.6, (double)16.0);
    public final DyeColor color;

    public BuriedPetalBlock(DyeColor color, BlockBehaviour.Properties builder) {
        super(builder);
        this.color = color;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        SparkleParticleData data = SparkleParticleData.noClip(rand.m_188501_(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
        world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.3 + (double)rand.m_188501_() * 0.5, (double)pos.m_123342_() + 0.1 + (double)rand.m_188501_() * 0.1, (double)pos.m_123343_() + 0.3 + (double)rand.m_188501_() * 0.5, 0.0, 0.0, 0.0);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_7370_(@NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, boolean fuckifiknow) {
        return world.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(@NotNull Level world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.m_7370_((BlockGetter)world, pos, state, false);
    }

    public void m_214148_(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = BotaniaBlocks.getDoubleFlower(this.color);
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)block.m_49966_(), (BlockPos)pos, (int)3);
        }
    }
}

