/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.shared;

import java.math.RoundingMode;
import java.text.NumberFormat;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.proxy.Proxy;

public class LocaleHelper {
    public static NumberFormat getIntegerFormat() {
        return NumberFormat.getIntegerInstance(Proxy.INSTANCE.getLocale());
    }

    @NotNull
    public static NumberFormat getPercentageFormat(int fractionDigits) {
        NumberFormat formatter = NumberFormat.getPercentInstance(Proxy.INSTANCE.getLocale());
        formatter.setMinimumFractionDigits(fractionDigits);
        formatter.setMaximumFractionDigits(fractionDigits);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        return formatter;
    }

    public static String formatAsPercentage(double value, int fractionDigits) {
        NumberFormat formatter = LocaleHelper.getPercentageFormat(fractionDigits);
        double minValue = Math.pow(10.0, -fractionDigits) / 100.0;
        return ((String)(value < minValue ? "< " + formatter.format(minValue) : formatter.format(value))).replace('\u00a0', ' ');
    }
}

