/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UpgradeHelper {
    public static void saveUpgradeMap(@NotNull CompoundTag tag, @NotNull Map<String, Short> upgradeMap) {
        ListTag upgradeList = new ListTag();
        for (Map.Entry<String, Short> entry : upgradeMap.entrySet()) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128359_("id", entry.getKey());
            compoundtag.m_128376_("lvl", entry.getValue().shortValue());
            upgradeList.add((Object)compoundtag);
        }
        tag.m_128365_("Upgrades", (Tag)upgradeList);
    }

    public static Map<String, Short> loadUpgradeMap(@NotNull CompoundTag tag) {
        HashMap<String, Short> upgradeMap = new HashMap<String, Short>();
        ListTag upgradeList = tag.m_128441_("Upgrades") ? tag.m_128437_("Upgrades", 10) : new ListTag();
        for (int i = 0; i < upgradeList.size(); ++i) {
            CompoundTag compoundtag = upgradeList.m_128728_(i);
            String id = compoundtag.m_128461_("id");
            Short lvl = compoundtag.m_128448_("lvl");
            upgradeMap.put(id, lvl);
        }
        return upgradeMap;
    }

    public static void upgrade(Map<String, Short> upgradeMap, String id) {
        short level = upgradeMap.getOrDefault(id, (short)0);
        upgradeMap.put(id, (short)(level + 1));
    }

    public static void downgrade(Map<String, Short> upgradeMap, String id) {
        short level = upgradeMap.getOrDefault(id, (short)0);
        if (level > 0) {
            upgradeMap.put(id, (short)(level - 1));
        }
    }

    public static Map<String, Short> getUpgradeMap(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("BlockEntityTag");
        if (compoundtag == null) {
            return null;
        }
        return UpgradeHelper.loadUpgradeMap(compoundtag);
    }

    public static int getUpgradeLevel(ItemStack stack, String id) {
        Map<String, Short> upgradeMap = UpgradeHelper.getUpgradeMap(stack);
        return upgradeMap == null ? -1 : (int)upgradeMap.getOrDefault(id, (short)0).shortValue();
    }

    public static Component getUpgradeName(String id, int level) {
        String descriptionID = "statues.upgrade." + id + ".name";
        MutableComponent mutablecomponent = Component.m_237115_((String)descriptionID).m_130940_(ChatFormatting.GRAY);
        if (level > 0) {
            mutablecomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + level)));
        }
        return mutablecomponent;
    }
}

