/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeType;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class UpgradeRecipeBuilder {
    private final Ingredient center;
    private final List<Ingredient> catalysts;
    private ItemStack result = ItemStack.f_41583_;
    private boolean requireCore = false;
    private UpgradeType upgradeType = UpgradeType.CRAFTING;
    private int tier = -1;
    private String group;

    private UpgradeRecipeBuilder(Ingredient center, List<Ingredient> catalysts) {
        this.center = center;
        this.catalysts = catalysts;
    }

    public static UpgradeRecipeBuilder upgrade(Ingredient statueIngredient, List<Ingredient> catalysts) {
        return new UpgradeRecipeBuilder(statueIngredient, catalysts);
    }

    public UpgradeRecipeBuilder result(ItemLike resultIn) {
        this.result = new ItemStack((ItemLike)resultIn.m_5456_());
        return this;
    }

    public UpgradeRecipeBuilder result(ItemStack resultIn) {
        this.result = resultIn;
        return this;
    }

    public UpgradeRecipeBuilder upgradeType(UpgradeType upgradeType) {
        this.upgradeType = upgradeType;
        return this;
    }

    public UpgradeRecipeBuilder tier(int tier) {
        this.tier = tier;
        return this;
    }

    public UpgradeRecipeBuilder requiresCore() {
        this.requireCore = true;
        return this;
    }

    public UpgradeRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.center, this.catalysts, this.result, this.requireCore, this.upgradeType, this.tier));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient center;
        private final List<Ingredient> catalysts;
        private final ItemStack result;
        private final boolean requireCore;
        private final UpgradeType upgradeType;
        private final int tier;

        public Result(ResourceLocation idIn, String groupIn, Ingredient center, List<Ingredient> catalysts, ItemStack result, boolean requireCore, UpgradeType upgradeType, int tier) {
            this.id = idIn;
            this.group = groupIn;
            this.center = center;
            this.catalysts = catalysts;
            this.result = result;
            this.requireCore = requireCore;
            this.upgradeType = upgradeType;
            this.tier = tier;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("center", this.center.m_43942_());
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.catalysts) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("catalysts", (JsonElement)jsonarray);
            this.addStack(json, "result", this.result);
            if (this.requireCore) {
                json.addProperty("requireCore", Boolean.valueOf(true));
            }
            json.addProperty("upgradeType", this.upgradeType.name().toLowerCase(Locale.ROOT));
            if (this.tier != -1) {
                json.addProperty("tier", (Number)this.tier);
            }
        }

        private void addStack(JsonObject json, String property, ItemStack stack) {
            if (stack != null && !stack.m_41619_()) {
                JsonObject object = new JsonObject();
                object.addProperty("item", Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
                if (stack.m_41613_() != 1) {
                    object.addProperty("count", (Number)stack.m_41613_());
                }
                if (stack.m_41782_()) {
                    object.addProperty("tag", stack.m_41783_().toString());
                }
                json.add(property, (JsonElement)object);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)StatuesRecipes.UPGRADE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

