/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shynieke.statues.compat.jei.JEIPlugin;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.registry.StatueRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class LootCategory
implements IRecipeCategory<LootRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public LootCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JEIPlugin.LOOT_BACKGROUND, 0, 0, 100, 62);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()));
        this.localizedName = Component.m_237115_((String)"statues.gui.jei.category.loot");
    }

    public RecipeType<LootRecipe> getRecipeType() {
        return JEIPlugin.LOOT_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LootRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 23).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 5).addItemStack(recipe.m_8043_());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 23).addItemStack(recipe.getResultItem2());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 41).addItemStack(recipe.getResultItem3());
    }

    public void draw(LootRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        font.m_92889_(stack, (Component)Component.m_237113_((String)((int)(100.0f * recipe.getChance1()) + "%")), 74.0f, 8.0f, 0);
        font.m_92889_(stack, (Component)Component.m_237113_((String)((int)(100.0f * recipe.getChance2()) + "%")), 74.0f, 27.0f, 0);
        font.m_92889_(stack, (Component)Component.m_237113_((String)((int)(100.0f * recipe.getChance3()) + "%")), 74.0f, 45.0f, 0);
    }

    public Component getTitle() {
        return this.localizedName;
    }
}

