/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.compat.jei.category.LootCategory;
import com.shynieke.statues.compat.jei.category.UpgradeCategory;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("statues", "main");
    public static final ResourceLocation LOOT_BACKGROUND = new ResourceLocation("statues", "textures/gui/jei/loot.png");
    public static final RecipeType<LootRecipe> LOOT_TYPE = RecipeType.create((String)"statues", (String)"loot", LootRecipe.class);
    public static final ResourceLocation UPGRADE_BACKGROUND = new ResourceLocation("statues", "textures/gui/jei/upgrade.png");
    public static final RecipeType<UpgradeRecipe> UPGRADE_TYPE = RecipeType.create((String)"statues", (String)"upgrade", UpgradeRecipe.class);
    @Nullable
    private IRecipeCategory<LootRecipe> lootCategory;
    @Nullable
    private IRecipeCategory<UpgradeRecipe> upgradeCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{LOOT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{UPGRADE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[2];
        this.lootCategory = new LootCategory(guiHelper);
        iRecipeCategoryArray[0] = this.lootCategory;
        this.upgradeCategory = new UpgradeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.upgradeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel clientLevel = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(LOOT_TYPE, clientLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)StatuesRecipes.LOOT_RECIPE.get()));
        registration.addRecipes(UPGRADE_TYPE, clientLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)StatuesRecipes.UPGRADE_RECIPE.get()));
        List<StatueBlockItem> statues = StatueRegistry.ITEMS.getEntries().stream().filter(registryObject -> {
            AbstractStatueBase statueBase;
            StatueBlockItem statueBlock;
            Block patt3536$temp;
            Object patt3465$temp = registryObject.get();
            return patt3465$temp instanceof StatueBlockItem && (patt3536$temp = (statueBlock = (StatueBlockItem)((Object)((Object)patt3465$temp))).m_40614_()) instanceof AbstractStatueBase && !(statueBase = (AbstractStatueBase)patt3536$temp).isHiddenStatue();
        }).map(registryObject -> (StatueBlockItem)((Object)((Object)registryObject.get()))).toList();
        double chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        for (StatueBlockItem statue : statues) {
            if (statue.getEntity() == null) {
                Statues.LOGGER.error("Tried adding info to statue but statue {} has no entity linked", (Object)ForgeRegistries.ITEMS.getKey((Object)statue));
                continue;
            }
            registration.addItemStackInfo(statue.m_7968_(), new Component[]{Component.m_237110_((String)"statues.gui.jei.statue.info", (Object[])new Object[]{Component.m_237115_((String)statue.m_5524_()).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD), Component.m_237113_((String)((int)(chance * 100.0) + "%")).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)statue.getEntity().m_20675_()).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)})});
        }
        registration.addItemStackInfo(((Item)StatueRegistry.STATUE_CORE.get()).m_7968_(), new Component[]{Component.m_237110_((String)"statues.gui.jei.statue_core.info", (Object[])new Object[]{Component.m_237115_((String)((Item)StatueRegistry.STATUE_CORE.get()).m_5524_()).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)((EntityType)StatueRegistry.STATUE_BAT.get()).m_20675_()).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)}), Component.m_237110_((String)"statues.gui.jei.statue_core.info2", (Object[])new Object[]{Component.m_237115_((String)((EntityType)StatueRegistry.STATUE_BAT.get()).m_20675_()).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)})});
        registration.addItemStackInfo(((Block)StatueRegistry.STATUE_TABLE.get()).m_5456_().m_7968_(), new Component[]{Component.m_237115_((String)"statues.gui.jei.statue_table.info"), Component.m_237115_((String)"statues.gui.jei.statue_table.info2"), Component.m_237115_((String)"statues.gui.jei.statue_table.info3"), Component.m_237115_((String)"statues.gui.jei.statue_table.info4"), Component.m_237115_((String)"statues.gui.jei.statue_table.info5"), Component.m_237115_((String)"statues.gui.jei.statue_table.info6"), Component.m_237115_((String)"statues.gui.jei.statue_table.info7"), Component.m_237115_((String)"statues.gui.jei.statue_table.info8")});
    }
}

