/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.registry;

import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class MissingMappingsHandler {
    private static final Map<String, String> NAME_REMAP = Map.ofEntries(Map.entry("tank", "container"), Map.entry("tank_small", "small_container"), Map.entry("tank_creative", "creative_container"), Map.entry("air_mill", "air_mill_grindstone"), Map.entry("inertcrystal", "inert_crystal"), Map.entry("crystalore", "inert_crystal_ore"), Map.entry("containedcrystal", "contained_crystal"), Map.entry("fire_lense", "fire_lens"), Map.entry("water_lense", "water_lens"), Map.entry("earth_lense", "earth_lens"), Map.entry("air_lense", "air_lens"), Map.entry("elementpipe_priority", "pipe_priority_rings"));

    private MissingMappingsHandler() {
    }

    @SubscribeEvent
    public static void remapMissingMappings(MissingMappingsEvent event) {
        MissingMappingsHandler.remapMissingMappings(event, event.getRegistry());
    }

    private static <T> void remapMissingMappings(MissingMappingsEvent event, IForgeRegistry<T> registry) {
        ResourceKey key = registry.getRegistryKey();
        if (!key.equals((Object)event.getKey())) {
            return;
        }
        Object defaultValue = registry.getDefaultKey() != null ? registry.getValue(registry.getDefaultKey()) : null;
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(key, "elementalcraft")) {
            Object entity;
            ResourceLocation oldId = mapping.getKey();
            String oldName = oldId.m_135815_();
            String newName = NAME_REMAP.get(oldName);
            if (newName == null || (entity = registry.getValue(ElementalCraft.createRL(newName))) == null || entity == defaultValue) continue;
            mapping.remap(entity);
            ElementalCraftApi.LOGGER.info(ForgeRegistry.REGISTRIES, "Re-mapped {} \"{}\" to \"{}\"", (Object)registry.getRegistryName(), (Object)oldName, (Object)newName);
        }
    }
}

