/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.jewel.DemigodJewel;
import sirttas.elementalcraft.jewel.HawkJewel;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.PiglinJewel;
import sirttas.elementalcraft.jewel.StriderJewel;
import sirttas.elementalcraft.jewel.attack.KirinJewel;
import sirttas.elementalcraft.jewel.attack.ViperJewel;
import sirttas.elementalcraft.jewel.attribute.BearJewel;
import sirttas.elementalcraft.jewel.attribute.DolphinJewel;
import sirttas.elementalcraft.jewel.attribute.LeopardJewel;
import sirttas.elementalcraft.jewel.attribute.TigerJewel;
import sirttas.elementalcraft.jewel.defence.ArcticHaresJewel;
import sirttas.elementalcraft.jewel.defence.TortoiseJewel;
import sirttas.elementalcraft.jewel.effect.BasiliskJewel;
import sirttas.elementalcraft.jewel.effect.PhoenixJewel;
import sirttas.elementalcraft.jewel.effect.SalmonJewel;
import sirttas.elementalcraft.jewel.effect.mole.MoleJewel;

public class Jewels {
    private static final DeferredRegister<Jewel> DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)ElementalCraft.createRL("jewel"), (String)"elementalcraft");
    public static final Supplier<IForgeRegistry<Jewel>> REGISTRY = DEFERRED_REGISTER.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<SalmonJewel> SALMON = Jewels.register("salmon", SalmonJewel::new);
    public static final RegistryObject<PhoenixJewel> PHOENIX = Jewels.register("phoenix", PhoenixJewel::new);
    public static final RegistryObject<BasiliskJewel> BASILISK = Jewels.register("basilisk", BasiliskJewel::new);
    public static final RegistryObject<BearJewel> BEAR = Jewels.register("bear", BearJewel::new);
    public static final RegistryObject<TigerJewel> TIGER = Jewels.register("tiger", TigerJewel::new);
    public static final RegistryObject<LeopardJewel> LEOPARD = Jewels.register("leopard", LeopardJewel::new);
    public static final RegistryObject<DolphinJewel> DOLPHIN = Jewels.register("dolphin", DolphinJewel::new);
    public static final RegistryObject<KirinJewel> KIRIN = Jewels.register("kirin", KirinJewel::new);
    public static final RegistryObject<ViperJewel> VIPER = Jewels.register("viper", ViperJewel::new);
    public static final RegistryObject<TortoiseJewel> TORTOISE = Jewels.register("tortoise", TortoiseJewel::new);
    public static final RegistryObject<ArcticHaresJewel> ARCTIC_HARES = Jewels.register("arctic_hares", ArcticHaresJewel::new);
    public static final RegistryObject<MoleJewel> MOLE = Jewels.register("mole", MoleJewel::new);
    public static final RegistryObject<HawkJewel> HAWK = Jewels.register("hawk", HawkJewel::new);
    public static final RegistryObject<DemigodJewel> DEMIGOD = Jewels.register("demigod", DemigodJewel::new);
    public static final RegistryObject<StriderJewel> STRIDER = Jewels.register("strider", () -> new StriderJewel(ElementType.FIRE, 10, (TagKey<Fluid>)FluidTags.f_13132_));
    public static final RegistryObject<StriderJewel> WATER_STRIDER = Jewels.register("water_strider", () -> new StriderJewel(ElementType.WATER, 10, (TagKey<Fluid>)FluidTags.f_13131_));
    public static final RegistryObject<PiglinJewel> PIGLIN = Jewels.register("piglin", PiglinJewel::new);

    private Jewels() {
    }

    private static <T extends Jewel> RegistryObject<T> register(String name, Supplier<? extends T> builder) {
        return DEFERRED_REGISTER.register(name, builder);
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(Consumer<ResourceLocation> addModel) {
        REGISTRY.get().getValues().forEach(jewel -> addModel.accept(jewel.getModelName()));
    }
}

