/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityHelper {
    private EntityHelper() {
    }

    public static Stream<ItemStack> handStream(Player player) {
        return Stream.of(player.m_21205_(), player.m_21206_());
    }

    public static HitResult rayTrace(Entity entity) {
        LivingEntity livingEntity;
        AttributeInstance reach;
        double range = 5.0;
        if (entity instanceof LivingEntity && (reach = (livingEntity = (LivingEntity)entity).m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null) {
            range = reach.m_22135_();
        }
        return EntityHelper.rayTrace(entity, range);
    }

    public static HitResult rayTrace(Entity entity, double range) {
        Vec3 eyePos = entity.m_20299_(1.0f);
        Vec3 look = entity.m_20252_(1.0f);
        Vec3 rayVector = eyePos.m_82520_(look.f_82479_ * range, look.f_82480_ * range, look.f_82481_ * range);
        BlockHitResult blockResult = entity.f_19853_.m_45547_(new ClipContext(eyePos, rayVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
        EntityHitResult entityResult = ProjectileUtil.m_37304_((Level)entity.m_9236_(), (Entity)entity, (Vec3)eyePos, (Vec3)rayVector, (AABB)entity.m_20191_().m_82369_(look.m_82490_(range)).m_82377_(1.0, 1.0, 1.0), e -> !e.m_5833_() && e.m_6087_());
        return entityResult != null && entityResult.m_82450_().m_82546_(eyePos).m_82553_() <= blockResult.m_82450_().m_82546_(eyePos).m_82553_() ? entityResult : blockResult;
    }

    public static boolean isHostile(Entity entity) {
        return entity instanceof Enemy;
    }

    public static boolean spawnMob(ServerLevel level, BlockPos pos) {
        return WeightedRandomList.m_146328_(level.m_7726_().m_8481_().m_223133_(level.m_204166_(pos), level.m_215010_(), MobCategory.MONSTER, pos).m_146338_().stream().filter(data -> EntityHelper.canSpawn(level, pos, data)).toList()).m_216829_(level.f_46441_).map(data -> EntityHelper.doSpawn(level, pos, data)).orElse(false);
    }

    private static boolean doSpawn(ServerLevel level, BlockPos pos, MobSpawnSettings.SpawnerData data) {
        Entity entity = data.f_48404_.m_20615_((Level)level);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (!ForgeEventFactory.doSpecialSpawn((Mob)mob, (LevelAccessor)level, (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.SPAWNER)) {
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, null, null);
            }
            level.m_47205_((Entity)mob);
            mob.m_21373_();
            return true;
        }
        return false;
    }

    private static boolean canSpawn(ServerLevel level, BlockPos pos, MobSpawnSettings.SpawnerData data) {
        EntityType entityType = data.f_48404_;
        if (entityType.m_20654_()) {
            SpawnPlacements.Type placementType = SpawnPlacements.m_21752_((EntityType)entityType);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)placementType, (LevelReader)level, (BlockPos)pos, (EntityType)entityType)) {
                return false;
            }
            if (!SpawnPlacements.m_217074_((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)pos, (RandomSource)level.f_46441_)) {
                return false;
            }
            return level.m_45772_(entityType.m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5));
        }
        return false;
    }

    public static boolean isFighting(Entity entity) {
        return EntityHelper.isFighting(entity, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFighting(Entity entity, int ticks) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.f_20922_ >= ticks) return false;
        return true;
    }
}

