/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.solar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SolarSynthesizerRenderer<T extends SolarSynthesizerBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Material BEAM = ECRendererHelper.getBlockMaterial("effect/solar_synthesizer_beam");
    public static final ResourceLocation LENSE_LOCATION = ElementalCraft.createRL("block/solar_synthesizer_lense");
    private static BakedModel lenseModel;

    public void render(T te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        ECRendererHelper.renderRunes(matrixStack, buffer, ((SolarSynthesizerBlockEntity)te).getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
        ElementType elementType = this.getElementType(te);
        if (elementType != ElementType.NONE) {
            Minecraft minecraft = Minecraft.m_91087_();
            float r = elementType.getRed();
            float g = elementType.getGreen();
            float b = elementType.getBlue();
            boolean isWorking = ((SolarSynthesizerBlockEntity)te).isWorking();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.90625, 0.5);
            if (isWorking) {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122270_(te.m_58904_().m_46490_(partialTicks)));
            } else {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
            matrixStack.m_85837_(-0.1875, -0.03125, -0.1875);
            minecraft.m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), te.m_58900_(), this.getLenseModel(), r, g, b, light, overlay, ECRendererHelper.getModelData(this.getLenseModel(), te), RenderType.m_110466_());
            matrixStack.m_85849_();
            if (isWorking) {
                Vec3 beamVect = Vec3.m_82512_((Vec3i)te.m_58899_()).m_82546_(minecraft.m_91290_().f_114358_.m_90583_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.acos(beamVect.f_82481_ * (double)(beamVect.f_82479_ > 0.0 ? 1 : -1))));
                matrixStack.m_85841_(0.006f, 0.006f, 0.006f);
                ECRendererHelper.renderIcon(matrixStack, buffer, -21.0f, 38.0f, BEAM, 42, -76, r, g, b, light, overlay);
                matrixStack.m_85849_();
            }
        }
    }

    protected ElementType getElementType(T te) {
        ItemStack stack = ((SolarSynthesizerBlockEntity)te).getInventory().m_8020_(0);
        if (!stack.m_41619_()) {
            ElementType elementType;
            Item item = stack.m_41720_();
            if (item instanceof IElementTypeProvider) {
                IElementTypeProvider elementTypeProvider = (IElementTypeProvider)item;
                elementType = elementTypeProvider.getElementType();
            } else {
                elementType = ElementType.NONE;
            }
            return elementType;
        }
        return ElementType.NONE;
    }

    protected synchronized BakedModel getLenseModel() {
        if (lenseModel == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            lenseModel = minecraft.m_91304_().getModel(LENSE_LOCATION);
        }
        return lenseModel;
    }
}

