/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.displacement.plate;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.displacement.plate.BrokenSourceDisplacementPlateBlock;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class SourceDisplacementPlateBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    private boolean running = false;
    private int runningTick = 0;

    public SourceDisplacementPlateBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE_DISPLACEMENT_PLATE, pos, state);
    }

    public static boolean hasSource(Level level, BlockPos pos, ElementType elementType) {
        BlockPos above = pos.m_7494_();
        BlockState state = level.m_8055_(above);
        return state.m_60734_() == ECBlocks.SOURCE.get() && ElementType.getElementType(state) == elementType && BlockEntityHelper.getBlockEntityAs((BlockGetter)level, above, SourceBlockEntity.class).filter(SourceBlockEntity::isAnalyzed).isPresent();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SourceDisplacementPlateBlockEntity sourceDisplacementPlate) {
        if (!sourceDisplacementPlate.running || !SourceDisplacementPlateBlockEntity.hasSource(level, pos, sourceDisplacementPlate.getElementType())) {
            return;
        }
        ++sourceDisplacementPlate.runningTick;
        if (sourceDisplacementPlate.runningTick >= 300) {
            sourceDisplacementPlate.runningTick = 0;
            sourceDisplacementPlate.running = false;
            if (!level.f_46443_) {
                SourceDisplacementPlateBlockEntity.spawnReceptacle(level, pos);
                level.m_46597_(pos, ((BrokenSourceDisplacementPlateBlock)((Object)ECBlocks.BROKEN_SOURCE_DISPLACEMENT_PLATE.get())).m_49966_());
                level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
            }
        }
    }

    private static void spawnReceptacle(Level level, BlockPos pos) {
        SourceBlockEntity source = BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos.m_7494_(), SourceBlockEntity.class).orElse(null);
        if (source == null) {
            return;
        }
        ItemStack receptacle = ReceptacleHelper.create(source.getElementType());
        if (source.isStabilized()) {
            source.setStabilized(false);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ECItems.SOURCE_STABILIZER.get())));
        }
        source.m_183515_(receptacle.m_41698_("BlockEntityTag"));
        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, receptacle));
    }

    @Override
    public ElementType getElementType() {
        return ((IElementTypeProvider)this.m_58900_().m_60734_()).getElementType();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public void start() {
        if (this.f_58857_ == null || !SourceDisplacementPlateBlockEntity.hasSource(this.f_58857_, this.m_58899_(), this.getElementType()) || this.running) {
            return;
        }
        this.running = true;
        this.runningTick = 0;
        this.m_6596_();
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.running = compound.m_128471_("running");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("running", this.running);
    }
}

