/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.entity;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.block.entity.ICraftingBlockEntity;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.recipe.IContainerBlockEntityRecipe;

public abstract class AbstractECCraftingBlockEntity<T extends ICraftingBlockEntity, R extends IContainerBlockEntityRecipe<T>>
extends AbstractECContainerBlockEntity
implements ICraftingBlockEntity {
    protected final RecipeType<R> recipeType;
    protected final int transferSpeed;
    protected final RuneHandler runeHandler;
    protected R recipe;
    protected int outputSlot = 0;

    protected AbstractECCraftingBlockEntity(Config<T, R> config, BlockPos pos, BlockState state) {
        super(config.blockEntityType(), pos, state);
        this.recipeType = config.recipeType() != null ? config.recipeType().get() : null;
        this.transferSpeed = config.transferSpeed().get();
        this.runeHandler = new RuneHandler(config.maxRunes().get(), this::m_6596_);
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.recipe != null && this.recipe.matches((ICraftingBlockEntity)this.cast())) {
            return true;
        }
        if (!this.getInventory().m_7983_()) {
            this.recipe = this.lookupRecipe();
            if (this.recipe != null) {
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Override
    public void process() {
        if (!this.f_58857_.f_46443_) {
            this.assemble();
            RetrieverBlock.sendOutputToRetriever(this.f_58857_, this.f_58858_, this.getInventory(), this.outputSlot);
        }
        this.recipe = null;
        this.m_6596_();
    }

    protected int getProgressRounded(float transferAmount, float progress) {
        return Math.round(progress / (transferAmount * 3.0f));
    }

    protected abstract void assemble();

    protected R lookupRecipe() {
        return (R)(this.f_58857_ != null ? this.lookupRecipe(this.f_58857_, this.recipeType) : null);
    }

    @Nonnull
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.RUNE_HANDLE) {
            return LazyOptional.of(this::getRuneHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public record Config<T extends ICraftingBlockEntity, R extends IContainerBlockEntityRecipe<T>>(Supplier<? extends BlockEntityType<?>> blockEntityType, Supplier<? extends RecipeType<R>> recipeType, Supplier<Integer> transferSpeed, Supplier<Integer> maxRunes) {
    }
}

