/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft;

import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.phys.AABB;

public class ElementalCraftUtils {
    private ElementalCraftUtils() {
    }

    public static <S, T> BiConsumer<S, Consumer<T>> cast(Class<T> clazz) {
        return (s, c) -> {
            if (clazz.isInstance(s)) {
                c.accept(clazz.cast(s));
            }
        };
    }

    public static AABB stitchAABB(AABB source) {
        return new AABB(Math.floor(source.f_82288_), Math.floor(source.f_82289_), Math.floor(source.f_82290_), Math.ceil(source.f_82291_), Math.ceil(source.f_82292_), Math.ceil(source.f_82293_));
    }

    public static <T, U> Predicate<T> distinctBy(Function<T, U> getter) {
        HashSet seen = new HashSet();
        return t -> seen.add(getter.apply(t));
    }
}

