/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.utils.BlockTypes;

public abstract class BlockInteractionTask
extends Task {
    protected static final ResourceLocation DEFAULT = new ResourceLocation("minecraft:dirt");
    private ResourceLocation block = DEFAULT;
    private long value = 100L;
    private BlockTypes type = BlockTypes.BLOCK;

    public BlockInteractionTask(Quest q) {
        super(q);
    }

    public BlockTypes getBlockType() {
        return this.type;
    }

    public ResourceLocation getBlock() {
        return this.block;
    }

    public boolean checkBlock(Block block) {
        if (this.type == BlockTypes.BLOCK) {
            return this.block.equals((Object)Registries.getId((Object)block, (ResourceKey)Registry.f_122901_));
        }
        return block.m_204297_().m_203656_(BlockTags.create((ResourceLocation)this.block));
    }

    public Component getBlockName() {
        if (this.type == BlockTypes.BLOCK) {
            return Component.m_237115_((String)("block." + this.block.m_135827_() + "." + this.block.m_135815_()));
        }
        return Component.m_237113_((String)this.block.toString());
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128405_("block_type", this.type.ordinal());
        nbt.m_128359_("block", this.block.toString());
        nbt.m_128356_("value", this.value);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.type = BlockTypes.values()[nbt.m_128451_("block_type")];
        this.block = new ResourceLocation(nbt.m_128461_("block"));
        this.value = nbt.m_128454_("value");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130068_((Enum)this.type);
        buffer.m_130072_(this.block.toString(), Short.MAX_VALUE);
        buffer.m_130103_(this.value);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.type = (BlockTypes)buffer.m_130066_(BlockTypes.class);
        this.block = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        this.value = buffer.m_130242_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("block_type", (Object)this.type, v -> {
            this.type = v;
        }, BlockTypes.NAME_MAP).setNameKey("questsadditions.task.block_interaction_type");
        config.addString("block", this.block.toString(), v -> {
            this.block = new ResourceLocation(v);
        }, "minecraft:dirt");
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("questsadditions.task.count");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        if (this.type == BlockTypes.BLOCK) {
            Item item = ((Block)Registry.f_122824_.m_7745_(this.block)).m_5456_();
            return ItemIcon.getItemIcon((Item)(item != null ? item : (Item)FTBQuestsItems.MISSING_ITEM.get()));
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (Holder block : Registry.f_122824_.m_206058_(BlockTags.create((ResourceLocation)this.block))) {
            Icon icon = ItemIcon.getItemIcon((ItemStack)new ItemStack((ItemLike)block.m_203334_()));
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }
}

