/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.mixin;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import questsadditions.mixinutils.IMixinQuest;

@Mixin(value={Quest.class})
public abstract class MixinQuest
implements IMixinQuest {
    boolean secret;
    int minRequiredTasks;
    public List<QuestObject> incompatible_quests = new ArrayList<QuestObject>(0);
    boolean isRepeatable;

    @Override
    public int getMinRequiredTasks() {
        return this.minRequiredTasks;
    }

    @Override
    public List<QuestObject> getIncompatibleQuests() {
        return this.incompatible_quests;
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Inject(method={"writeData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")}, remap=false)
    private void writeData(CompoundTag nbt, CallbackInfo callback) {
        if (this.secret) {
            nbt.m_128379_("secret", this.secret);
        }
        if (this.isRepeatable) {
            nbt.m_128379_("repeatable", this.isRepeatable);
        }
        if (this.minRequiredTasks > 0) {
            nbt.m_128405_("min_required_tasks", this.minRequiredTasks);
        }
        if (!this.incompatible_quests.isEmpty()) {
            this.incompatible_quests.removeIf(o -> o == null || o.invalid || o == this.This());
        }
        if (!this.incompatible_quests.isEmpty()) {
            ListTag quests = new ListTag();
            for (QuestObject quest : this.incompatible_quests) {
                quests.add((Object)StringTag.m_129297_((String)quest.getCodeString()));
            }
            nbt.m_128365_("incompatible", (Tag)quests);
        }
    }

    @Inject(method={"readData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")}, remap=false)
    private void readData(CompoundTag nbt, CallbackInfo callback) {
        this.secret = nbt.m_128471_("secret");
        this.isRepeatable = nbt.m_128471_("repeatable");
        this.minRequiredTasks = nbt.m_128451_("min_required_tasks");
        this.incompatible_quests.clear();
        ListTag quests = nbt.m_128437_("incompatible", 8);
        Quest quest = this.This();
        for (int i = 0; i < quests.size(); ++i) {
            QuestObject object = quest.chapter.file.get(quest.chapter.file.getID((Object)quests.m_128778_(i)));
            if (object == null) continue;
            this.incompatible_quests.add(object);
        }
    }

    @Inject(method={"writeNetData(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")}, remap=false)
    public void writeNetData(FriendlyByteBuf buffer, CallbackInfo callback) {
        buffer.writeBoolean(this.secret);
        buffer.writeBoolean(this.isRepeatable);
        buffer.m_130130_(this.minRequiredTasks);
        buffer.m_130130_(this.incompatible_quests.size());
        for (QuestObject quest : this.incompatible_quests) {
            if (quest.invalid) {
                buffer.writeLong(0L);
                continue;
            }
            buffer.writeLong(quest.id);
        }
    }

    @Inject(method={"readNetData(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")}, remap=false)
    public void readNetData(FriendlyByteBuf buffer, CallbackInfo callback) {
        this.secret = buffer.readBoolean();
        this.isRepeatable = buffer.readBoolean();
        this.minRequiredTasks = buffer.m_130242_();
        this.incompatible_quests.clear();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            QuestObject object = this.This().chapter.file.get(buffer.readLong());
            if (object == null) continue;
            this.incompatible_quests.add(object);
        }
    }

    @Inject(method={"isVisible(Ldev/ftb/mods/ftbquests/quest/TeamData;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void isVisible(TeamData team, CallbackInfoReturnable<Boolean> cir) {
        Quest quest;
        if (this.secret && !team.isCompleted((QuestObject)(quest = this.This()))) {
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"getConfig(Ldev/ftb/mods/ftblibrary/config/ConfigGroup;)V"}, at={@At(value="TAIL")}, remap=false)
    public void getConfig(ConfigGroup config, CallbackInfo callback) {
        config.addBool("is_secret", this.secret, v -> {
            this.secret = v;
        }, false).setNameKey("questsadditions.is_secret");
        config.addBool("repeatable", this.isRepeatable, v -> {
            this.isRepeatable = v;
        }, false).setNameKey("questsadditions.repeatable");
        config.addInt("min_required_tasks", this.minRequiredTasks, v -> {
            this.minRequiredTasks = v;
        }, 0, 0, Integer.MAX_VALUE).setNameKey("questsadditions.min_required_tasks");
        Quest quest = this.This();
        Predicate<QuestObjectBase> depTypes = object -> object != quest.chapter.file && object != quest.chapter && object instanceof QuestObject;
        this.incompatible_quests.removeIf(Objects::isNull);
        config.addList("incompatible_quests", this.incompatible_quests, (ConfigValue)new ConfigQuestObject(depTypes), null).setNameKey("questsadditions.incompatible_quests");
    }

    @Inject(method={"isCompletedRaw(Ldev/ftb/mods/ftbquests/quest/TeamData;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void isCompletedRaw(TeamData data, CallbackInfoReturnable<Boolean> cir) {
        if (this.minRequiredTasks > 0) {
            Quest quest = this.This();
            int completed = 0;
            for (QuestObject child : quest.getChildren()) {
                if (!data.isCompleted(child) || ++completed != this.minRequiredTasks) continue;
                if (data.canStartTasks(quest)) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getRelativeProgressFromChildren(Ldev/ftb/mods/ftbquests/quest/TeamData;)I"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getRelativeProgressFromChildren(TeamData data, CallbackInfoReturnable<Integer> cir) {
        if (!this.incompatible_quests.isEmpty()) {
            for (QuestObject object : this.incompatible_quests) {
                if (object.invalid || !data.isCompleted(object)) continue;
                cir.setReturnValue((Object)0);
                return;
            }
        }
    }

    private Quest This() {
        return (Quest)this;
    }
}

