/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.power;

import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PolyItemEnergyStorage
extends PolyEnergyStorage
implements IPolyEnergyStorageItem {
    private final ItemStack stack;

    public PolyItemEnergyStorage(ItemStack stack, long capacity) {
        super(capacity);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxTransfer) {
        super(capacity, maxTransfer);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxReceive, long maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxReceive, long maxExtract, Runnable changeListener) {
        super(capacity, maxReceive, maxExtract, changeListener);
        this.stack = stack;
        this.loadEnergy();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.saveEnergy();
    }

    private void loadEnergy() {
        if (this.stack.m_41782_()) {
            this.energy = this.stack.m_41784_().m_128454_("item_energy");
        }
    }

    private void saveEnergy() {
        this.stack.m_41784_().m_128356_("item_energy", this.energy);
    }

    @Override
    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }
}

