/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screenbuilder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Optional;
import net.creeperhost.polylib.client.fluid.ScreenFluidRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ScreenBuilder {
    public static final ResourceLocation DEFAULT_RESOURCE_LOCATION = new ResourceLocation("polylib", "textures/gui_sheet.png");
    public final ResourceLocation resourceLocation;

    public ScreenBuilder() {
        this.resourceLocation = DEFAULT_RESOURCE_LOCATION;
    }

    public ScreenBuilder(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void drawDefaultBackground(Screen screen, PoseStack poseStack, int x, int y, int width, int height, int textureXSize, int textureYSize) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)(width / 2), (int)(height / 2), (int)textureXSize, (int)textureYSize);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2), (int)y, (float)(150 - width / 2), (float)0.0f, (int)(width / 2), (int)(height / 2), (int)textureXSize, (int)textureYSize);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)(y + height / 2), (float)0.0f, (float)(150 - height / 2), (int)(width / 2), (int)(height / 2), (int)textureXSize, (int)textureYSize);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + width / 2), (int)(y + height / 2), (float)(150 - width / 2), (float)(150 - height / 2), (int)(width / 2), (int)(height / 2), (int)textureXSize, (int)textureYSize);
    }

    public void drawPlayerSlots(Screen screen, PoseStack poseStack, int posX, int posY, boolean center, int textureXSize, int textureYSize) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + x * 18), (int)(posY + y * 18), (float)150.0f, (float)0.0f, (int)18, (int)18, (int)textureXSize, (int)textureYSize);
            }
        }
        for (int x = 0; x < 9; ++x) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(posX + x * 18), (int)(posY + 58), (float)150.0f, (float)0.0f, (int)18, (int)18, (int)textureXSize, (int)textureYSize);
        }
    }

    public void drawSlot(Screen gui, PoseStack poseStack, int posX, int posY, int textureXSize, int textureYSize) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)150.0f, (float)0.0f, (int)18, (int)18, (int)textureXSize, (int)textureYSize);
    }

    public void drawProgressBar(Screen gui, PoseStack poseStack, int progress, int maxProgress, int x, int y, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)150.0f, (float)18.0f, (int)23, (int)15, (int)256, (int)256);
        int j = (int)((double)progress / (double)maxProgress * 24.0);
        if (j < 0) {
            j = 0;
        }
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)173.0f, (float)18.0f, (int)j, (int)16, (int)256, (int)256);
        if (this.isInRect(x, y, 26, 15, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237113_((String)(this.getPercentageColour(percentage) + percentage + "%")));
            gui.m_169388_(poseStack, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawTankWithOverlay(Screen gui, PoseStack poseStack, FluidStack fluidStack, int capacity, int x, int y, int height, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)228.0f, (float)18.0f, (int)22, (int)56, (int)256, (int)256);
        ScreenFluidRenderer screenFluidRenderer = new ScreenFluidRenderer(capacity, 16, height, 0);
        screenFluidRenderer.render(x + 3, y + 3, fluidStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 3), (int)(y + 3), (float)231.0f, (float)74.0f, (int)16, (int)50, (int)256, (int)256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (fluidStack.getFluid() != null) {
                list.add(Component.m_237113_((String)(fluidStack.getAmount() + " / " + capacity + " " + fluidStack.getName().getString())));
            } else {
                list.add(Component.m_237113_((String)"empty"));
            }
            gui.m_169388_(poseStack, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void drawBar(Screen screen, PoseStack poseStack, int x, int y, int height, int value, int maxValue, int mouseX, int mouseY, Component tooltip) {
        poseStack.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
        int draw = (int)((double)value / (double)maxValue * (double)(height - 2));
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)1.0f, (float)150.0f, (int)13, (int)height, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 1), (int)(y + height - draw - 1), (float)14.0f, (float)150.0f, (int)12, (int)draw, (int)256, (int)256);
        if (this.isInRect(x, y, 14, height, mouseX, mouseY)) {
            screen.m_96602_(poseStack, tooltip, mouseX, mouseY);
        }
        poseStack.m_85849_();
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public ChatFormatting getPercentageColour(int percentage) {
        if (percentage <= 10) {
            return ChatFormatting.RED;
        }
        if (percentage >= 75) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.YELLOW;
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }
}

