/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.HashSet;
import java.util.Set;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.containers.PolyBlockContainerMenu;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.creeperhost.polylib.data.TileDataManager;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.BooleanData;
import net.creeperhost.polylib.data.serializable.EnumData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PolyBlockEntity
extends BlockEntity
implements Nameable,
DataManagerBlock,
DataRetainingBlock {
    private final TileDataManager<PolyBlockEntity> dataManager = new TileDataManager<PolyBlockEntity>(this);
    private final Set<Player> accessingPlayers = new HashSet<Player>();
    private Component customName = null;
    private int tick = 0;
    private EnumData<RedstoneActivatedBlock.RSMode> redstoneMode = null;
    private BooleanData isPowered = null;

    public PolyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (this instanceof RedstoneActivatedBlock) {
            this.redstoneMode = this.register("rs_mode", new EnumData<RedstoneActivatedBlock.RSMode>(RedstoneActivatedBlock.RSMode.ALWAYS_ACTIVE), 9, 4, 2);
            this.isPowered = this.register("rs_powered", new BooleanData(false), 8, 4);
        }
    }

    public TileDataManager<PolyBlockEntity> getDataManager() {
        return this.dataManager;
    }

    public <D extends AbstractDataStore<?>> D register(String name, D data, int ... flags) {
        return this.dataManager.register(name, data, flags);
    }

    public void tick() {
        ++this.tick;
        this.dataManager.tick();
    }

    public Set<Player> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt3231$temp = e.f_36096_;
            if (!(patt3231$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt3231$temp;
            if (container.tile == this) return false;
            return true;
        });
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(Player player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(Player player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> {
            AbstractContainerMenu patt3616$temp = e.f_36096_;
            if (!(patt3616$temp instanceof PolyBlockContainerMenu)) return true;
            PolyBlockContainerMenu container = (PolyBlockContainerMenu)patt3616$temp;
            if (container.tile == this) return false;
            return true;
        });
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    public Component m_7755_() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.dataManager.save(nbt);
        this.writeExtraData(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.dataManager.load(nbt);
        this.readExtraData(nbt);
    }

    @Override
    public void writeToItemStack(CompoundTag nbt, boolean willHarvest) {
        this.dataManager.saveToItem(nbt);
        this.writeExtraData(nbt);
    }

    @Override
    public void readFromItemStack(CompoundTag nbt) {
        this.dataManager.loadFromItem(nbt);
        this.readExtraData(nbt);
    }

    public void writeExtraData(CompoundTag nbt) {
    }

    public void readExtraData(CompoundTag nbt) {
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public RedstoneActivatedBlock.RSMode getRSMode() {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return (RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get());
    }

    public void setRSMode(RedstoneActivatedBlock.RSMode mode) {
        if (!(this instanceof RedstoneActivatedBlock)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        if (this.f_58857_.f_46443_) {
            this.sendDataValueToServer(this.redstoneMode, (Object)mode);
        } else {
            this.redstoneMode.set(mode);
        }
    }

    public void cycleRSMode(boolean reverse) {
        this.redstoneMode.set(((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).next(reverse));
    }

    public boolean isTileEnabled() {
        if (this instanceof RedstoneActivatedBlock) {
            return ((RedstoneActivatedBlock.RSMode)((Object)this.redstoneMode.get())).canRun((Boolean)this.isPowered.get());
        }
        return true;
    }

    public void onNeighborChange(Block fromBlock, BlockPos fromPos, boolean isMoving) {
        if (this instanceof RedstoneActivatedBlock) {
            boolean lastSignal = (Boolean)this.isPowered.get();
            this.isPowered.set(this.f_58857_.m_46753_(this.f_58858_));
            if ((Boolean)this.isPowered.get() != lastSignal) {
                this.onSignalChange((Boolean)this.isPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }
}

