/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.internal.command.EntityTypeArgument;
import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.covers1624.quack.collection.StreamableIterable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.registries.ForgeRegistries;

public class KillAllCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"killall").requires(e -> e.m_6761_(2))).then(Commands.m_82129_((String)"entity", EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType entityType = (EntityType)EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)ctx, "entity").m_203334_();
            return KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.m_6095_(), entityType));
        }))).executes(ctx -> KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gracefully").then(Commands.m_82129_((String)"entity", EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType entityType = (EntityType)EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)ctx, "entity").m_203334_();
            return KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.m_6095_(), entityType));
        }))).executes(ctx -> KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy)))));
    }

    private static int killAllGracefully(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, type, predicate, Entity::m_6074_);
    }

    private static int killallForce(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, type, predicate, Entity::m_146870_);
    }

    private static int killEntities(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate, Consumer<Entity> killFunc) {
        if (type == EntityType.f_20532_) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"ccl.commands.killall.fail.player").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel world = source.m_81372_();
        ServerChunkCache provider = world.m_7726_();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        StreamableIterable<Entity> entities = StreamableIterable.of(world.m_142646_().m_142273_()).filter(Objects::nonNull).filter(predicate).filter(e -> provider.m_5563_(MathHelper.floor(e.m_20185_()) >> 4, MathHelper.floor(e.m_20189_()) >> 4));
        for (Entity e2 : entities) {
            killFunc.accept(e2);
            int count = counts.getInt((Object)e2.m_6095_());
            counts.put((Object)e2.m_6095_(), count + 1);
        }
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType t : order) {
            int count = counts.getInt((Object)t);
            String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)t).toString();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)"ccl.commands.killall.success.line", (Object[])new Object[]{ChatFormatting.RED + name + ChatFormatting.RESET + " x " + ChatFormatting.AQUA + count}), false);
            total += count;
        }
        if (order.size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237115_((String)"ccl.commands.killall.fail"), false);
        } else if (order.size() > 1) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)"ccl.commands.killall.success", (Object[])new Object[]{ChatFormatting.AQUA.toString() + total + ChatFormatting.RESET}), false);
        }
        return total;
    }
}

