/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.module.ModuleCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockUtils {
    public static BiPredicate<Level, BlockPos> CLAIMED_CHUNK_CHECKER = (world, pos) -> true;

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.f_82289_; y < axisAlignedBB.f_82292_; y += 1.0) {
            for (double x = axisAlignedBB.f_82288_; x < axisAlignedBB.f_82291_; x += 1.0) {
                for (double z = axisAlignedBB.f_82290_; z < axisAlignedBB.f_82293_; z += 1.0) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static boolean isBlockstateInMaterial(BlockState state, Material[] materials) {
        for (Material material : materials) {
            if (state.m_60767_() != material) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTag(Level world, BlockPos pos, TagKey<Block> tag) {
        return BlockUtils.isBlockStateTag(world.m_8055_(pos), tag);
    }

    public static boolean isBlockStateTag(BlockState state, TagKey<Block> tag) {
        return state.m_204336_(tag);
    }

    public static boolean isLog(Level world, BlockPos pos) {
        return BlockUtils.isBlockTag(world, pos, (TagKey<Block>)BlockTags.f_13106_);
    }

    public static boolean isLeaves(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_() == Material.f_76274_ || world.m_8055_(pos).m_204336_(BlockTags.f_13078_) || world.m_8055_(pos).m_204336_(BlockTags.f_13035_) || world.m_8055_(pos).m_60734_().equals(Blocks.f_50701_);
    }

    public static boolean isChorus(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_().equals(Blocks.f_50490_) || world.m_8055_(pos).m_60734_().equals(Blocks.f_50491_);
    }

    public static boolean canBlockBeBroken(Level world, BlockPos pos) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), (Player)IndustrialForegoing.getFakePlayer(world));
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static boolean canBlockBeBrokenPlugin(Level world, BlockPos pos) {
        return CLAIMED_CHUNK_CHECKER.test(world, pos);
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos) {
        return BlockUtils.getBlockDrops(world, pos, 0);
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos, int fortune) {
        BlockState state = world.m_8055_(pos);
        NonNullList stacks = NonNullList.m_122779_();
        stacks.addAll((Collection)Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos)));
        return stacks;
    }

    public static boolean spawnItemStack(ItemStack stack, Level world, BlockPos pos) {
        ItemEntity item = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, stack);
        item.m_20334_(0.0, -1.0, 0.0);
        item.m_32010_(40);
        item.m_32045_(stack);
        return world.m_7967_((Entity)item);
    }

    public static int getStackAmountByRarity(Rarity rarity) {
        if (rarity.equals((Object)Rarity.COMMON)) {
            return 2048;
        }
        if (rarity.equals((Object)ModuleCore.PITY_RARITY)) {
            return 16384;
        }
        if (rarity.equals((Object)ModuleCore.SIMPLE_RARITY)) {
            return 524288;
        }
        if (rarity.equals((Object)ModuleCore.ADVANCED_RARITY)) {
            return 0x4000000;
        }
        return Integer.MAX_VALUE;
    }

    public static int getFluidAmountByRarity(Rarity rarity) {
        if (rarity.equals((Object)Rarity.COMMON)) {
            return 16000;
        }
        if (rarity.equals((Object)ModuleCore.PITY_RARITY)) {
            return 64000;
        }
        if (rarity.equals((Object)ModuleCore.SIMPLE_RARITY)) {
            return 1024000;
        }
        if (rarity.equals((Object)ModuleCore.ADVANCED_RARITY)) {
            return 65536000;
        }
        return Integer.MAX_VALUE;
    }

    public static void renderLaserBeam(BlockEntity tile, double x, double y, double z, Direction direction, float partialTicks, int length) {
    }
}

