/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelAHConnect;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityAbsorptionRenderer
implements BlockEntityRenderer<TileEntityAbsorptionHopper> {
    private static final ResourceLocation ITEM_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/absorption_hopper_connects_items.png");
    private static final ResourceLocation FLUID_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/absorption_hopper_connects_fluids.png");
    private final ModelAHConnect connectionModel;

    public TileEntityAbsorptionRenderer(BlockEntityRendererProvider.Context context) {
        this.connectionModel = new ModelAHConnect(context.m_173582_(ModelLayers.ABSORPTION_HOPPER));
    }

    public void render(TileEntityAbsorptionHopper tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.m_58898_()) {
            return;
        }
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (state == null || state.m_60734_() != ModBlocks.ABSORPTION_HOPPER.getBlock()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        for (Direction facing : Direction.values()) {
            if (tile.status[facing.ordinal()] == TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_ITEM) {
                matrixStack.m_85836_();
                this.getRotTranslation(matrixStack, facing);
                this.connectionModel.m_7695_(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)ITEM_TEXTURE)), combinedLight, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
                matrixStack.m_85849_();
            }
            if (tile.status[facing.ordinal()] != TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_FLUID) continue;
            matrixStack.m_85836_();
            this.getRotTranslation(matrixStack, facing);
            this.connectionModel.m_7695_(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)FLUID_TEXTURE)), combinedLight, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        if (!tile.showRenderBox) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(-5.0E-4, -5.0E-4, -5.0E-4);
        matrixStack.m_85841_(0.999f, 0.999f, 0.999f);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)tile.getAABBForRender(), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        matrixStack.m_85849_();
    }

    public void getRotTranslation(PoseStack matrixStack, Direction facing) {
        switch (facing) {
            case UP: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                break;
            }
            case DOWN: {
                break;
            }
            case NORTH: {
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
        }
    }
}

