/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.lib.PotionEffectTags;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EffectDispel
extends AbstractEffect {
    public static EffectDispel INSTANCE = new EffectDispel();

    private EffectDispel() {
        super(GlyphLib.EffectDispelID, "Dispel");
    }

    @Override
    public void onResolveEntity(@NotNull EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Collection effects = entity2.m_21220_();
            MobEffectInstance[] array = effects.toArray(new MobEffectInstance[0]);
            Optional blacklist = Registry.f_122823_.m_203431_(PotionEffectTags.DISPEL_DENY);
            Optional whitelist = Registry.f_122823_.m_203431_(PotionEffectTags.DISPEL_ALLOW);
            for (MobEffectInstance e : array) {
                if (e.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))) {
                    if (blacklist.isPresent() && ((HolderSet.Named)blacklist.get()).m_203614_().anyMatch(effect -> effect.get() == e.m_19544_())) continue;
                    entity2.m_21195_(e.m_19544_());
                    continue;
                }
                if (!whitelist.isPresent() || !((HolderSet.Named)whitelist.get()).m_203614_().anyMatch(effect -> effect.get() == e.m_19544_())) continue;
                entity2.m_21195_(e.m_19544_());
            }
            if (!entity2.m_6084_() || entity2.m_21223_() <= 0.0f || entity2.m_213877_()) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new DispelEvent.Pre((HitResult)rayTraceResult, world, shooter, spellStats, spellContext))) {
                return;
            }
            if (entity2 instanceof IDispellable) {
                IDispellable iDispellable = (IDispellable)entity2;
                iDispellable.onDispel(shooter);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DispelEvent.Post((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        IDispellable dispellable;
        if (MinecraftForge.EVENT_BUS.post((Event)new DispelEvent.Pre((HitResult)rayTraceResult, world, shooter, spellStats, spellContext))) {
            return;
        }
        BlockState blockState = world.m_8055_(rayTraceResult.m_82425_());
        if (blockState instanceof IDispellable) {
            dispellable = (IDispellable)blockState;
            dispellable.onDispel(shooter);
        }
        if ((blockState = world.m_7702_(rayTraceResult.m_82425_())) instanceof IDispellable) {
            dispellable = (IDispellable)blockState;
            dispellable.onDispel(shooter);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DispelEvent.Post((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Removes any potion effects on the target. When used on a witch at half health, the witch will vanish in return for a Wixie shard. Will also dispel tamed summons back into their charm.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ABJURATION);
    }
}

