/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.perk.TotemPerk;
import com.hollingsworth.arsnouveau.common.perk.VampiricPerk;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class PerkEvents {
    @SubscribeEvent
    public static void equipmentChangedEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().f_19853_.f_46443_ && (livingEntity = event.getEntity()) instanceof Player) {
            List<PerkInstance> toInstances;
            Player player = (Player)livingEntity;
            if (event.getSlot().m_20743_() != EquipmentSlot.Type.ARMOR) {
                return;
            }
            List<PerkInstance> perkInstances = PerkUtil.getPerksFromItem(event.getFrom());
            if (perkInstances.equals(toInstances = PerkUtil.getPerksFromItem(event.getTo()))) {
                return;
            }
            ArrayList<IPerk> playerPerks = new ArrayList<IPerk>(PerkUtil.getPerksFromPlayer(player).stream().map(PerkInstance::getPerk).toList());
            List<IPerk> itemPerks = PerkUtil.getPerksFromItem(event.getTo()).stream().map(PerkInstance::getPerk).toList();
            for (IPerk perk : itemPerks) {
                playerPerks.remove(perk);
            }
            for (IPerk equippedPerks : playerPerks) {
                if (!itemPerks.contains(equippedPerks)) continue;
                PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.perks.duplicated"));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void spellDamageEvent(SpellDamageEvent.Post event) {
        Player player;
        int vampLevel;
        LivingEntity livingEntity = event.caster;
        if (livingEntity instanceof Player && (vampLevel = PerkUtil.countForPerk(VampiricPerk.INSTANCE, player = (Player)livingEntity)) > 0) {
            float healAmount = event.damage * (0.2f * (float)vampLevel);
            player.m_5634_(healAmount);
        }
    }

    @SubscribeEvent
    public static void totemEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IPerkHolder<ItemStack> holder = PerkUtil.getHolderForPerk(TotemPerk.INSTANCE, player);
            if (holder == null) {
                return;
            }
            TotemPerk.Data perkData = new TotemPerk.Data(holder);
            if (!perkData.isActive()) {
                return;
            }
            entity.m_21153_(1.0f);
            entity.m_21219_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            entity.f_19853_.m_7605_((Entity)entity, (byte)35);
            perkData.setActive(false);
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.totem_perk.trigger"));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void sleepEvent(SleepFinishedTimeEvent event) {
        for (Player p : event.getLevel().m_6907_()) {
            IPerkHolder<ItemStack> holder = PerkUtil.getHolderForPerk(TotemPerk.INSTANCE, p);
            if (holder == null) continue;
            TotemPerk.Data perkData = new TotemPerk.Data(holder);
            perkData.setActive(true);
            PortUtil.sendMessage((Entity)p, (Component)Component.m_237115_((String)"ars_nouveau.totem_perk.active"));
        }
    }
}

