/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.util.CompactingUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompactingStackItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    public static String PARENT = "Parent";
    public static String BIG_ITEMS = "BigItems";
    public static String STACK = "Stack";
    public static String AMOUNT = "Amount";
    public int totalAmount;
    private int amount;
    private ItemStack parent;
    private List<CompactingUtil.Result> resultList;
    private int slots;
    private int multiplier;
    private boolean downgrade;
    private boolean isVoid;
    private boolean isCreative;
    private ItemStack stack;

    public CompactingStackItemHandler(ItemStack stack, int slots) {
        int i;
        this.stack = stack;
        this.resultList = new ArrayList<CompactingUtil.Result>();
        this.slots = slots;
        this.totalAmount = 512;
        for (i = 0; i < slots - 1; ++i) {
            this.totalAmount *= 9;
        }
        for (i = 0; i < slots; ++i) {
            this.resultList.add(i, new CompactingUtil.Result(ItemStack.f_41583_, 1));
        }
        this.parent = ItemStack.f_41583_;
        this.multiplier = 1;
        this.downgrade = false;
        this.isVoid = false;
        this.isCreative = false;
        if (stack.m_41782_()) {
            ItemStack itemStack;
            this.deserializeNBT(stack.m_41783_().m_128469_("Tile").m_128469_("handler"));
            for (Tag tag : stack.m_41784_().m_128469_("Tile").m_128469_("storageUpgrades").m_128437_("Items", 10)) {
                itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                if (itemStack.m_41720_() instanceof StorageUpgradeItem) {
                    this.multiplier = this.multiplier == 1 ? ((StorageUpgradeItem)itemStack.m_41720_()).getStorageMultiplier() : (this.multiplier *= ((StorageUpgradeItem)itemStack.m_41720_()).getStorageMultiplier());
                }
                if (itemStack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                    this.downgrade = true;
                }
                if (!itemStack.m_41720_().equals(FunctionalStorage.CREATIVE_UPGRADE.get())) continue;
                this.isCreative = true;
            }
            for (Tag tag : stack.m_41784_().m_128469_("Tile").m_128469_("utilityUpgrades").m_128437_("Items", 10)) {
                itemStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag));
                if (!itemStack.m_41720_().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
        }
    }

    public int getSlots() {
        if (this.isVoid()) {
            return this.slots + 1;
        }
        return this.slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.slots) {
            return ItemStack.f_41583_;
        }
        CompactingUtil.Result bigStack = this.resultList.get(slot);
        ItemStack copied = bigStack.getResult().m_41777_();
        copied.m_41764_(this.isCreative() ? Integer.MAX_VALUE : this.amount / bigStack.getNeeded());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isVoid() && slot == this.slots && this.isVoidValid(stack) || this.isVoidValid(stack) && this.isCreative()) {
            return ItemStack.f_41583_;
        }
        if (this.isValid(slot, stack)) {
            CompactingUtil.Result result = this.resultList.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) * result.getNeeded() - this.amount, stack.m_41613_() * result.getNeeded());
            inserted = (int)(Math.floor(inserted / result.getNeeded()) * (double)result.getNeeded());
            if (!simulate) {
                this.amount = Math.min(this.amount + inserted, this.totalAmount * this.getMultiplier());
                this.onChange();
            }
            if (inserted == stack.m_41613_() * result.getNeeded() || this.isVoid()) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted / result.getNeeded()));
        }
        return stack;
    }

    private boolean isVoidValid(ItemStack stack) {
        for (CompactingUtil.Result result : this.resultList) {
            if (!result.getResult().m_41656_(stack) || !ItemStack.m_41658_((ItemStack)result.getResult(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isSetup() {
        return !this.resultList.get(this.resultList.size() - 1).getResult().m_41619_();
    }

    public void setup(CompactingUtil compactingUtil) {
        this.resultList = compactingUtil.getResults();
        this.parent = compactingUtil.getResults().get(0).getResult();
        if (this.parent.m_41619_()) {
            this.parent = compactingUtil.getResults().get(1).getResult();
        }
        if (this.parent.m_41619_() && compactingUtil.getResults().size() >= 3) {
            this.parent = compactingUtil.getResults().get(2).getResult();
        }
        this.onChange();
    }

    public void reset() {
    }

    public int getAmount() {
        return this.amount;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot == this.slots) {
            return ItemStack.f_41583_;
        }
        if (slot < this.slots) {
            CompactingUtil.Result bigStack = this.resultList.get(slot);
            if (bigStack.getResult().m_41619_()) {
                return ItemStack.f_41583_;
            }
            int stackAmount = bigStack.getNeeded() * amount;
            if (stackAmount >= this.amount) {
                ItemStack out = bigStack.getResult().m_41777_();
                int newAmount = (int)Math.floor(this.amount / bigStack.getNeeded());
                if (!simulate && !this.isCreative()) {
                    this.amount -= newAmount * bigStack.getNeeded();
                    if (this.amount == 0) {
                        this.reset();
                    }
                    this.onChange();
                }
                out.m_41764_(newAmount);
                return out;
            }
            if (!simulate && !this.isCreative()) {
                this.amount -= stackAmount;
                this.onChange();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getResult(), (int)amount);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        if (slot == this.slots) {
            return Integer.MAX_VALUE;
        }
        int total = this.totalAmount;
        if (this.hasDowngrade()) {
            total = 5184;
        }
        return (int)Math.min(2.147483647E9, Math.floor(total * this.getMultiplier() / this.resultList.get(slot).getNeeded()));
    }

    public int getSlotLimitBase(int slot) {
        if (slot == this.slots) {
            return Integer.MAX_VALUE;
        }
        int total = this.totalAmount;
        if (this.hasDowngrade()) {
            total = 5184;
        }
        return (int)Math.min(2.147483647E9, Math.floor(total / this.resultList.get(slot).getNeeded()));
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.isSetup() && !stack.m_41619_();
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.slots) {
            CompactingUtil.Result bigStack = this.resultList.get(slot);
            ItemStack fl = bigStack.getResult();
            return !fl.m_41619_() && fl.m_41656_(stack) && ItemStack.m_41658_((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_(PARENT, (Tag)this.getParent().serializeNBT());
        compoundTag.m_128405_(AMOUNT, this.amount);
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.resultList.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.m_128365_(STACK, (Tag)this.resultList.get(i).getResult().serializeNBT());
            bigStack.m_128405_(AMOUNT, this.resultList.get(i).getNeeded());
            items.m_128365_("" + i, (Tag)bigStack);
        }
        compoundTag.m_128365_(BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.parent = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(PARENT));
        this.amount = nbt.m_128451_(AMOUNT);
        for (String allKey : nbt.m_128469_(BIG_ITEMS).m_128431_()) {
            this.resultList.get(Integer.parseInt(allKey)).setResult(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128469_(STACK)));
            this.resultList.get(Integer.parseInt(allKey)).setNeeded(Math.max(1, nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128451_(AMOUNT)));
        }
    }

    public void onChange() {
        if (this.stack.m_41784_().m_128441_("Tile")) {
            this.stack.m_41784_().m_128365_("Tile", (Tag)new CompoundTag());
        }
        this.stack.m_41784_().m_128469_("Tile").m_128365_("handler", (Tag)this.serializeNBT());
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public List<CompactingUtil.Result> getResultList() {
        return this.resultList;
    }

    public ItemStack getParent() {
        return this.parent;
    }

    public boolean hasDowngrade() {
        return this.downgrade;
    }

    public boolean isCreative() {
        return this.isCreative;
    }
}

