/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.reaper.common.blockentity;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.item.ItemContainerBlock;
import earth.terrarium.botarium.api.item.SimpleItemContainer;
import earth.terrarium.reaper.common.blockentity.SelfIdentifyingRuneBlockEntity;
import earth.terrarium.reaper.common.config.ReaperConfig;
import earth.terrarium.reaper.common.registry.ReaperRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.codexadrian.spirit.data.MobTraitData;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.data.ToolType;
import me.codexadrian.spirit.entity.EntityRarity;
import me.codexadrian.spirit.registry.SpiritBlocks;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SoulBeaconBlockEntity
extends BlockEntity
implements EnergyBlock,
ItemContainerBlock,
IAnimatable {
    private InsertOnlyEnergyContainer energyContainer;
    private SimpleItemContainer itemContainer;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int timer = 0;
    private static final List<BlockPos> offsets = new ArrayList<BlockPos>(List.of(new BlockPos(1, -1, 0), new BlockPos(1, -1, -1), new BlockPos(1, -1, 1), new BlockPos(0, -1, 1), new BlockPos(0, -1, -1), new BlockPos(-1, -1, 1), new BlockPos(-1, -1, 0), new BlockPos(-1, -1, -1)));
    private final List<BlockPos> runePositions = new ArrayList<BlockPos>();

    public SoulBeaconBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ReaperRegistry.SOUL_BEACON_BLOCK_ENTITY.get(), blockPos, blockState);
        this.runePositions.addAll(offsets.stream().map(pos -> pos.m_121955_((Vec3i)blockPos)).toList());
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, (long)ReaperConfig.soulBeaconEnergyCap)) : this.energyContainer;
    }

    public void tick() {
        ServerLevel serverLevel;
        block14: {
            block13: {
                Level level;
                if (!this.f_58857_.m_5776_() && this.timer > 0) {
                    --this.timer;
                }
                if (!((level = this.f_58857_) instanceof ServerLevel)) break block13;
                serverLevel = (ServerLevel)level;
                if (this.timer == 0 && !this.getContainer().m_7983_() && this.getContainer().m_8020_(0).m_150930_((Item)SpiritItems.SOUL_CRYSTAL.get())) break block14;
            }
            return;
        }
        boolean beastia = false;
        float dilato = 1.0f;
        boolean duplici = false;
        boolean efficio = false;
        boolean hostilis = false;
        ArrayList<UUID> whitelist = new ArrayList<UUID>();
        ArrayList<UUID> blacklist = new ArrayList<UUID>();
        for (BlockPos runePosition : this.runePositions) {
            BlockEntity blockEntity;
            BlockState block = this.m_58904_().m_8055_(runePosition);
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_NEUTRAL_FILTER.get())) {
                beastia = true;
                continue;
            }
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_RANGE.get())) {
                dilato = 1.2f;
                continue;
            }
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_DOUBLE.get())) {
                duplici = true;
                continue;
            }
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_EFFICIENCY.get())) {
                efficio = true;
                continue;
            }
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_HOSTILE_FILTER.get())) {
                hostilis = true;
                continue;
            }
            if (block.m_60713_(ReaperRegistry.RUNE_BLOCK_PERSONAL_FILTER.get()) && (blockEntity = this.m_58904_().m_7702_(runePosition)) instanceof SelfIdentifyingRuneBlockEntity) {
                SelfIdentifyingRuneBlockEntity runeBlockEntity = (SelfIdentifyingRuneBlockEntity)blockEntity;
                if (runeBlockEntity.isWhitelist()) {
                    whitelist.add(runeBlockEntity.getOwner());
                    continue;
                }
                blacklist.add(runeBlockEntity.getOwner());
                continue;
            }
            if (block.m_60713_((Block)SpiritBlocks.SOUL_STEEL_BLOCK.get())) continue;
            return;
        }
        String soulCrystalType = SoulUtils.getSoulCrystalType((ItemStack)this.getContainer().m_8020_(0));
        Tier tier = SoulUtils.getTier((ItemStack)this.getContainer().m_8020_(0), (Level)this.f_58857_);
        float range = (float)tier.spawnRange() * dilato;
        AABB box = new AABB(this.m_58899_()).m_82377_((double)range, 5.0, (double)range);
        if (soulCrystalType == null) {
            return;
        }
        boolean finalHostilis = hostilis;
        boolean finalBeastia = beastia;
        boolean finalDuplici = duplici;
        boolean finalEfficio = efficio;
        EntityType.m_20632_((String)soulCrystalType).ifPresent(entityType -> {
            int energyDrain = (int)((double)(finalEfficio ? 1000 : 2000) * EntityRarity.getRarity((EntityType)entityType).energyModifer);
            if (this.getEnergyStorage().internalExtract((long)energyDrain, true) < (long)energyDrain) {
                return;
            }
            this.timer += tier.minSpawnDelay();
            for (LivingEntity livingEntity : this.f_58857_.m_45976_(LivingEntity.class, box)) {
                if (livingEntity instanceof Player && (!whitelist.isEmpty() && !whitelist.contains(livingEntity.m_20148_()) || blacklist.contains(livingEntity.m_20148_())) || livingEntity instanceof Enemy && !finalHostilis || (livingEntity instanceof NeutralMob || livingEntity instanceof Animal) && !finalBeastia) continue;
                MobTraitData.getEffectForEntity((EntityType)entityType, (RecipeManager)serverLevel.m_7465_()).ifPresent(mobTraitData -> mobTraitData.traits().forEach(trait -> trait.onHitEntity(ToolType.SWORD, null, (Entity)livingEntity)));
                if (finalDuplici) {
                    MobTraitData.getEffectForEntity((EntityType)entityType, (RecipeManager)serverLevel.m_7465_()).ifPresent(mobTraitData -> mobTraitData.traits().forEach(trait -> trait.onHitEntity(ToolType.SWORD, null, (Entity)livingEntity)));
                }
                this.getEnergyStorage().internalExtract((long)energyDrain, false);
            }
        });
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
    }

    public void update() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::idle));
    }

    public PlayState idle(AnimationEvent<SoulBeaconBlockEntity> event) {
        if (!this.getContainer().m_7983_() && this.getEnergyStorage().getStoredEnergy() > 0L) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("active", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SimpleItemContainer getContainer() {
        return this.itemContainer == null ? (this.itemContainer = new SimpleItemContainer((BlockEntity)this, 1)) : this.itemContainer;
    }
}

