/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.block.entity.duct;

import cofh.core.network.packet.client.ModelUpdatePacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.lib.api.IConveyableData;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITileLocation;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.item.RedprintItem;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.attachment.AttachmentHelper;
import cofh.thermal.dynamics.attachment.AttachmentRegistry;
import cofh.thermal.dynamics.attachment.EmptyAttachment;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import cofh.thermal.dynamics.client.model.data.DuctModelData;
import cofh.thermal.dynamics.grid.Grid;
import cofh.thermal.dynamics.grid.GridNode;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public abstract class DuctBlockEntity<G extends Grid<G, N>, N extends GridNode<G>>
extends BlockEntity
implements IDuct<G, N>,
ITileLocation,
IPacketHandlerTile {
    protected final DuctModelData modelData = new DuctModelData();
    @Nullable
    protected G grid = null;
    protected IDuct.ConnectionType[] connections = new IDuct.ConnectionType[]{IDuct.ConnectionType.ALLOWED, IDuct.ConnectionType.ALLOWED, IDuct.ConnectionType.ALLOWED, IDuct.ConnectionType.ALLOWED, IDuct.ConnectionType.ALLOWED, IDuct.ConnectionType.ALLOWED};
    protected IAttachment[] attachments = new IAttachment[]{EmptyAttachment.INSTANCE, EmptyAttachment.INSTANCE, EmptyAttachment.INSTANCE, EmptyAttachment.INSTANCE, EmptyAttachment.INSTANCE, EmptyAttachment.INSTANCE};
    protected int redstonePower;

    public DuctBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.modelData.setNeedsRefresh();
    }

    public boolean attemptConnect(Direction side) {
        if (this.f_58857_ == null || Utils.isClientWorld((Level)this.f_58857_)) {
            return false;
        }
        IDuct<?, ?> adjacent = GridHelper.getGridHost((BlockGetter)this.m_58904_(), this.m_58899_().m_121945_(side));
        if (adjacent instanceof DuctBlockEntity) {
            DuctBlockEntity other = (DuctBlockEntity)adjacent;
            IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)this.f_58857_);
            if (gridContainer == null || other.connections[side.m_122424_().ordinal()] == IDuct.ConnectionType.FORCED) {
                return false;
            }
            this.connections[side.ordinal()] = IDuct.ConnectionType.ALLOWED;
            other.connections[side.m_122424_().ordinal()] = IDuct.ConnectionType.ALLOWED;
            if (!gridContainer.onDuctSideConnected(this, side)) {
                this.connections[side.ordinal()] = IDuct.ConnectionType.DISABLED;
                other.connections[side.m_122424_().ordinal()] = IDuct.ConnectionType.DISABLED;
                return false;
            }
            this.m_6596_();
            other.m_6596_();
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
            TileStatePacket.sendToClient((IPacketHandlerTile)other);
        } else {
            this.connections[side.ordinal()] = IDuct.ConnectionType.ALLOWED;
            this.m_6596_();
            this.callNeighborStateChange();
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        return true;
    }

    public boolean attemptDisconnect(Direction side, Player player) {
        if (this.attemptAttachmentRemove(side, player)) {
            return true;
        }
        if (this.f_58857_ == null || Utils.isClientWorld((Level)this.f_58857_)) {
            return false;
        }
        IDuct<?, ?> adjacent = GridHelper.getGridHost((BlockGetter)this.f_58857_, this.m_58899_().m_121945_(side));
        if (adjacent instanceof DuctBlockEntity) {
            DuctBlockEntity other = (DuctBlockEntity)adjacent;
            IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)this.f_58857_);
            if (gridContainer == null) {
                return false;
            }
            gridContainer.onDuctSideDisconnecting(this, side);
            this.connections[side.ordinal()] = IDuct.ConnectionType.DISABLED;
            other.connections[side.m_122424_().ordinal()] = IDuct.ConnectionType.DISABLED;
            this.m_6596_();
            other.m_6596_();
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
            TileStatePacket.sendToClient((IPacketHandlerTile)other);
        } else {
            this.connections[side.ordinal()] = IDuct.ConnectionType.DISABLED;
            this.m_6596_();
            this.callNeighborStateChange();
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
        return true;
    }

    public boolean attemptAttachmentInstall(Direction side, Player player, String type) {
        if (this.attachments[side.ordinal()] != EmptyAttachment.INSTANCE) {
            return false;
        }
        IAttachment attachment = AttachmentRegistry.getAttachment(type, new CompoundTag(), this, side);
        if (attachment == null || attachment == EmptyAttachment.INSTANCE) {
            return false;
        }
        this.attachments[side.ordinal()] = attachment;
        this.connections[side.ordinal()] = IDuct.ConnectionType.FORCED;
        ItemStack offhand = player.m_21120_(InteractionHand.OFF_HAND);
        if (offhand.m_41782_() && offhand.m_41720_() instanceof RedprintItem) {
            this.attachmentRedprintInteraction(offhand, side, player);
        }
        this.m_6596_();
        this.callNeighborStateChange();
        TileStatePacket.sendToClient((IPacketHandlerTile)this);
        return true;
    }

    public boolean attemptAttachmentRemove(Direction side, Player player) {
        ItemStack attachmentItem = this.attachments[side.ordinal()].getItem();
        if (!attachmentItem.m_41619_()) {
            if (player == null || !player.m_36356_(attachmentItem)) {
                Utils.dropDismantleStackIntoWorld((ItemStack)attachmentItem, (Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            this.attachments[side.ordinal()] = EmptyAttachment.INSTANCE;
            IDuct<?, ?> adjacent = GridHelper.getGridHost((BlockGetter)this.f_58857_, this.m_58899_().m_121945_(side));
            this.connections[side.ordinal()] = adjacent == null ? IDuct.ConnectionType.ALLOWED : IDuct.ConnectionType.DISABLED;
            this.m_6596_();
            this.callNeighborStateChange();
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
            return true;
        }
        return false;
    }

    public boolean attachmentRedprintInteraction(ItemStack stack, Direction side, Player player) {
        IAttachment iAttachment;
        if (side != null && (iAttachment = this.attachments[side.ordinal()]) instanceof IConveyableData) {
            IConveyableData conveyableData = (IConveyableData)iAttachment;
            if (stack.m_41783_() == null) {
                conveyableData.writeConveyableData(player, stack.m_41784_());
                if (stack.m_41783_().m_128456_()) {
                    stack.m_41751_(null);
                    return false;
                }
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 0.7f);
                return true;
            }
            conveyableData.readConveyableData(player, stack.m_41783_());
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.5f, 0.8f);
            return true;
        }
        return false;
    }

    public boolean openDuctGui(Player player) {
        DuctBlockEntity ductBlockEntity = this;
        if (ductBlockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)ductBlockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.pos());
            return true;
        }
        return false;
    }

    public boolean openAttachmentGui(Direction side, Player player) {
        IAttachment iAttachment;
        if (side != null && (iAttachment = this.attachments[side.ordinal()]) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)iAttachment;
            AttachmentHelper.openAttachmentScreen((ServerPlayer)player, provider, this.pos(), side);
            return true;
        }
        return false;
    }

    public void dropAttachments() {
        for (Direction dir : Constants.DIRECTIONS) {
            ItemStack attachmentItem = this.attachments[dir.ordinal()].getItem();
            if (attachmentItem.m_41619_()) continue;
            Utils.dropDismantleStackIntoWorld((ItemStack)attachmentItem, (Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
    }

    public void dismantleAttachments(Player player, boolean returnDrops) {
        for (Direction dir : Constants.DIRECTIONS) {
            ItemStack attachmentItem = this.attachments[dir.ordinal()].getItem();
            if (attachmentItem.m_41619_()) continue;
            if (!returnDrops || player == null || !player.m_36356_(attachmentItem)) {
                Utils.dropDismantleStackIntoWorld((ItemStack)attachmentItem, (Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            this.attachments[dir.ordinal()] = EmptyAttachment.INSTANCE;
        }
    }

    public void calcDuctModelDataServer() {
        if (this.f_58857_ == null || Utils.isClientWorld((Level)this.f_58857_) || this.getGrid() == null) {
            return;
        }
        this.modelData.clearState();
        for (Direction dir : Direction.values()) {
            if (((Grid)this.getGrid()).isConnectedTo(this.f_58858_, this.f_58858_.m_121945_(dir))) {
                this.modelData.setInternalConnection(dir, true);
            }
            if (this.connections[dir.ordinal()] != IDuct.ConnectionType.FORCED) continue;
            this.modelData.setExternalConnection(dir, true);
        }
        if (this.getNode() == null) {
            return;
        }
        Iterator iterator = this.getNode().getConnections().iterator();
        while (iterator.hasNext()) {
            Direction dir;
            this.modelData.setExternalConnection(dir, this.connections[(dir = (Direction)iterator.next()).ordinal()] != IDuct.ConnectionType.DISABLED);
        }
    }

    @Nonnull
    public DuctModelData getDuctModelData() {
        if (this.modelData.needsRefresh()) {
            this.calcDuctModelDataServer();
        }
        return this.modelData;
    }

    protected void callNeighborStateChange() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.pos(), this.block());
    }

    protected abstract boolean canConnectToBlock(Direction var1);

    @Nonnull
    public ModelData getModelData() {
        this.modelData.clearState();
        for (Direction dir : Constants.DIRECTIONS) {
            IDuct<?, ?> adjacent = GridHelper.getGridHost((BlockGetter)this.f_58857_, this.m_58899_().m_121945_(dir));
            this.modelData.setInternalConnection(dir, adjacent != null && this.canConnectTo(adjacent, dir) && adjacent.canConnectTo(this, dir.m_122424_()));
            this.modelData.setExternalConnection(dir, this.canConnectToBlock(dir) || this.connections[dir.ordinal()] == IDuct.ConnectionType.FORCED);
            this.modelData.setAttachment(dir, this.attachments[dir.ordinal()].getTexture());
        }
        return ModelData.builder().with(DuctModelData.DUCT_MODEL_DATA, (Object)this.modelData).build();
    }

    public FriendlyByteBuf getRedstonePacket(FriendlyByteBuf buffer) {
        buffer.writeInt(this.redstonePower);
        return buffer;
    }

    public void handleRedstonePacket(FriendlyByteBuf buffer) {
        int power = buffer.readInt();
        for (IAttachment attachment : this.attachments) {
            if (!(attachment instanceof IRedstoneControllableAttachment)) continue;
            IRedstoneControllableAttachment redstoneControllableAttachment = (IRedstoneControllableAttachment)attachment;
            redstoneControllableAttachment.redstoneControl().setPower(power);
        }
    }

    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        this.modelData.setNeedsRefresh();
        for (IDuct.ConnectionType connection : this.connections) {
            buffer.writeByte(connection.ordinal());
        }
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < 6; ++i) {
            CompoundTag attachmentTag = new CompoundTag();
            this.attachments[i].write(attachmentTag);
            if (attachmentTag.m_128456_()) continue;
            tag.m_128365_("Attachment" + i, (Tag)attachmentTag);
        }
        buffer.m_130079_(tag);
        return buffer;
    }

    public void handleStatePacket(FriendlyByteBuf buffer) {
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = IDuct.ConnectionType.VALUES[buffer.readByte()];
        }
        CompoundTag tag = buffer.m_130260_();
        if (tag != null) {
            for (int i = 0; i < 6; ++i) {
                if (tag.m_128441_("Attachment" + i)) {
                    CompoundTag attachmentTag = tag.m_128469_("Attachment" + i);
                    this.attachments[i] = AttachmentRegistry.getAttachment(attachmentTag.m_128461_("Type"), attachmentTag, this, Constants.DIRECTIONS[i]);
                    continue;
                }
                this.attachments[i] = EmptyAttachment.INSTANCE;
            }
        }
        this.requestModelDataUpdate();
    }

    public CompoundTag m_5995_() {
        this.modelData.setNeedsRefresh();
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        this.redstonePower = tag.m_128451_("RSPower");
        byte[] bConn = tag.m_128463_("Sides");
        if (bConn.length == 6) {
            for (i = 0; i < 6; ++i) {
                this.connections[i] = IDuct.ConnectionType.VALUES[bConn[i]];
            }
        }
        for (i = 0; i < 6; ++i) {
            if (tag.m_128441_("Attachment" + i)) {
                CompoundTag attachmentTag = tag.m_128469_("Attachment" + i);
                this.attachments[i] = AttachmentRegistry.getAttachment(attachmentTag.m_128461_("Type"), attachmentTag, this, Constants.DIRECTIONS[i]);
                continue;
            }
            this.attachments[i] = EmptyAttachment.INSTANCE;
        }
    }

    public void m_183515_(CompoundTag tag) {
        int i;
        super.m_183515_(tag);
        tag.m_128405_("RSPower", this.redstonePower);
        byte[] bConn = new byte[6];
        for (i = 0; i < 6; ++i) {
            bConn[i] = (byte)this.connections[i].ordinal();
        }
        tag.m_128382_("Sides", bConn);
        for (i = 0; i < 6; ++i) {
            CompoundTag attachmentTag = new CompoundTag();
            this.attachments[i].write(attachmentTag);
            if (attachmentTag.m_128456_()) continue;
            tag.m_128365_("Attachment" + i, (Tag)attachmentTag);
        }
    }

    @Override
    public final Level getHostWorld() {
        return this.world();
    }

    @Override
    public final BlockPos getHostPos() {
        return this.pos();
    }

    @Override
    public boolean hasGrid() {
        return this.grid != null;
    }

    @Override
    public final G getGrid() {
        if (this.f_58857_.f_46443_) {
            throw new UnsupportedOperationException("No grid representation on client.");
        }
        if (this.grid == null) {
            IGridContainer gridContainer = IGridContainer.getCapability((LevelAccessor)this.f_58857_);
            assert (gridContainer != null);
            this.grid = gridContainer.getGrid(this.getGridType(), this.m_58899_());
        }
        return this.grid;
    }

    @Override
    public final void setGrid(G grid) {
        if (this.f_58857_.f_46443_) {
            throw new UnsupportedOperationException("No grid representation on client.");
        }
        this.grid = grid;
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        Direction dir = BlockHelper.getSide((BlockPos)fromPos.m_121996_((Vec3i)this.f_58858_));
        if (dir != null) {
            this.attachments[dir.ordinal()].invalidate();
        }
        if (this.f_58857_ != null) {
            this.redstonePower = this.f_58857_.m_46755_(this.f_58858_);
            for (IAttachment attachment : this.attachments) {
                if (!(attachment instanceof IRedstoneControllableAttachment)) continue;
                IRedstoneControllableAttachment redstoneControllableAttachment = (IRedstoneControllableAttachment)attachment;
                redstoneControllableAttachment.redstoneControl().setPower(this.redstonePower);
            }
            TileRedstonePacket.sendToClient((IPacketHandlerTile)this);
        }
        this.modelData.setNeedsRefresh();
    }

    @Override
    public void onAttachmentUpdate() {
        this.modelData.setNeedsRefresh();
        this.m_6596_();
        this.callNeighborStateChange();
        ModelUpdatePacket.sendToClient((Level)this.m_58904_(), (BlockPos)this.m_58899_());
    }

    @Override
    @Nonnull
    public IAttachment getAttachment(Direction dir) {
        return this.attachments[dir.ordinal()];
    }

    @Override
    public boolean canConnectTo(IDuct<?, ?> other, Direction dir) {
        return IDuct.super.canConnectTo(other, dir) && this.connections[dir.ordinal()].allowDuctConnection();
    }

    @Override
    public IDuct.ConnectionType getConnectionType(Direction dir) {
        return this.connections[dir.ordinal()];
    }

    @Override
    public void setConnectionType(Direction dir, IDuct.ConnectionType type) {
        this.connections[dir.ordinal()] = type;
        this.m_6596_();
        this.callNeighborStateChange();
        TileStatePacket.sendToClient((IPacketHandlerTile)this);
    }

    public Block block() {
        return this.m_58900_().m_60734_();
    }

    public BlockState state() {
        return this.m_58900_();
    }

    public BlockPos pos() {
        return this.f_58858_;
    }

    public Level world() {
        return this.f_58857_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side == null || this.f_58857_ == null || this.f_58857_.f_46443_ || this.connections[side.ordinal()] == IDuct.ConnectionType.DISABLED || this.getGrid() == null) {
            return LazyOptional.empty();
        }
        return this.attachments[side.ordinal()].wrapGridCapability(cap, ((Grid)this.getGrid()).getCapability(cap));
    }
}

