/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.TransparentParticle;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleGhost
extends TransparentParticle {
    private final SpriteSet spriteSet;
    private final double mX;
    private final double mZ;

    private ParticleGhost(SpriteSet spriteSet, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y + 1.0, z);
        this.mX = motionX;
        this.mZ = motionZ;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.m_107257_(200);
        this.f_107219_ = false;
        this.m_6569_(8.0f);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.spriteSet = spriteSet;
        this.m_108339_(this.spriteSet);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.m_107276_()) {
            if (this.f_107224_ == 10) {
                this.f_107215_ = this.mX;
                this.f_107217_ = this.mZ;
            }
            float ratio = (float)this.f_107224_ / (float)this.f_107225_;
            this.m_107271_((1.0f - ratio) * 0.8f);
            this.m_108339_(this.spriteSet);
            if (this.f_107208_.f_46443_) {
                ClientUtils.produceGraveSmoke((Level)this.f_107208_, this.f_107212_, this.f_107213_ - 1.0, this.f_107214_);
            }
        }
    }

    protected int m_6355_(float partialTick) {
        int skylight = 15;
        int blocklight = 15;
        return skylight << 20 | blocklight << 4;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            RandomSource rand = world == null ? RandomSource.m_216337_() : world.f_46441_;
            return new ParticleGhost(this.spriteSet, world, x, y, z, WorldHelper.getRandom(rand, -0.05, 0.05), 0.0, WorldHelper.getRandom(rand, -0.05, 0.05));
        }
    }
}

