/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.forge;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.teamresourceful.resourcefulconfig.common.annotations.ByteRange;
import com.teamresourceful.resourcefulconfig.common.annotations.DoubleRange;
import com.teamresourceful.resourcefulconfig.common.annotations.FloatRange;
import com.teamresourceful.resourcefulconfig.common.annotations.IntRange;
import com.teamresourceful.resourcefulconfig.common.annotations.LongRange;
import com.teamresourceful.resourcefulconfig.common.annotations.ShortRange;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ForgeConfigUtils {
    public static <T> void setEntry(ForgeConfigSpec.ConfigValue<T> value, Object object) {
        if (object.getClass().isArray()) {
            value.set(new ArrayList<Object>(List.of((Object[])object)));
        } else {
            value.set(object);
        }
    }

    public static ForgeConfigSpec.ConfigValue<?> addEntry(ForgeConfigSpec.Builder builder, String id, Field field, EntryType type, Object defaultValue) {
        boolean isArray = field.getType().isArray();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.BOOLEAN -> builder.define(id, ((Boolean)defaultValue).booleanValue());
            case EntryType.BYTE -> {
                ByteRange range = field.getAnnotation(ByteRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Byte)) return false;
                        Byte value = (Byte)o;
                        if (range == null) return true;
                        if (value < range.min()) return false;
                        if (value > range.max()) return false;
                        return true;
                    });
                }
                byte value = (Byte)defaultValue;
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, (int)value, (int)range.min(), (int)range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, value, Byte.class, builder);
            }
            case EntryType.SHORT -> {
                ShortRange range = field.getAnnotation(ShortRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Short)) return false;
                        Short value = (Short)o;
                        if (range == null) return true;
                        if (value < range.min()) return false;
                        if (value > range.max()) return false;
                        return true;
                    });
                }
                short value = (Short)defaultValue;
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, (int)value, (int)range.min(), (int)range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, value, Short.class, builder);
            }
            case EntryType.INTEGER -> {
                IntRange range = field.getAnnotation(IntRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Integer)) return false;
                        Integer value = (Integer)o;
                        if (range == null) return true;
                        if (value < range.min()) return false;
                        if (value > range.max()) return false;
                        return true;
                    });
                }
                int value = (Integer)defaultValue;
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, value, range.min(), range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, value, Integer.class, builder);
            }
            case EntryType.LONG -> {
                LongRange range = field.getAnnotation(LongRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Long)) return false;
                        Long value = (Long)o;
                        if (range == null) return true;
                        if (value < range.min()) return false;
                        if (value > range.max()) return false;
                        return true;
                    });
                }
                long value = (Long)defaultValue;
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, value, range.min(), range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, value, Long.class, builder);
            }
            case EntryType.FLOAT -> {
                FloatRange range = field.getAnnotation(FloatRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Float)) return false;
                        Float value = (Float)o;
                        if (range == null) return true;
                        if (!(value.floatValue() >= range.min())) return false;
                        if (!(value.floatValue() <= range.max())) return false;
                        return true;
                    });
                }
                float value = ((Float)defaultValue).floatValue();
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, (double)value, (double)range.min(), (double)range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, Float.valueOf(value), Float.class, builder);
            }
            case EntryType.DOUBLE -> {
                DoubleRange range = field.getAnnotation(DoubleRange.class);
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> {
                        if (!(o instanceof Double)) return false;
                        Double value = (Double)o;
                        if (range == null) return true;
                        if (!(value >= range.min())) return false;
                        if (!(value <= range.max())) return false;
                        return true;
                    });
                }
                double value = (Double)defaultValue;
                if (range != null) {
                    if (value < range.min() || value > range.max()) {
                        throw new IllegalArgumentException("Default value for " + id + " is out of range");
                    }
                    yield builder.defineInRange(id, value, range.min(), range.max());
                }
                yield ForgeConfigUtils.defineNumber(id, value, Double.class, builder);
            }
            case EntryType.STRING -> {
                if (isArray) {
                    yield builder.defineList(id, ParsingUtils.toList(defaultValue), o -> o instanceof String);
                }
                yield builder.define(id, defaultValue);
            }
            case EntryType.ENUM -> {
                if (isArray) {
                    throw new RuntimeException("Arrays of enums are not supported");
                }
                yield builder.defineEnum(id, (Enum)defaultValue);
            }
        };
    }

    public static ForgeConfigSpec.ConfigValue<?> defineNumber(String id, Number defaultValue, Class<? extends Number> clazz, ForgeConfigSpec.Builder builder) {
        return builder.define((List)Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)id)), () -> defaultValue, o -> o instanceof Number, clazz);
    }
}

