/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.forge;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import com.teamresourceful.resourcefulconfig.common.config.ConfigLoader;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.forge.ForgeConfigParser;
import com.teamresourceful.resourcefulconfig.common.config.forge.ForgeResourcefulConfig;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public final class ForgeConfigLoader
implements ConfigLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ForgeConfigSpec, ForgeResourcefulConfig> configCache = new ConcurrentHashMap<ForgeConfigSpec, ForgeResourcefulConfig>();
    private final boolean forceLoad;

    public ForgeConfigLoader(boolean forceLoad) {
        this.forceLoad = forceLoad;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onConfigLoad);
        bus.addListener(this::onConfigReloaded);
    }

    @Override
    public ResourcefulConfig registerConfig(Class<?> configClass) {
        try {
            ModLoadingContext context = ModLoadingContext.get();
            ForgeResourcefulConfig config = ForgeConfigParser.parseConfig(configClass);
            this.configCache.put(config.getSpec(), config);
            ModContainer container = context.getActiveContainer();
            ResourcefulModConfig modConfig = new ResourcefulModConfig(ModConfig.Type.COMMON, (IConfigSpec<?>)config.getSpec(), container, config.getFileName() + ".toml");
            container.addConfig((ModConfig)modConfig);
            if (this.forceLoad) {
                ForgeConfigLoader.forceLoad(modConfig, container);
            }
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Failed to register config for class: {}", (Object)configClass.getName());
            return null;
        }
    }

    private static void forceLoad(ResourcefulModConfig config, ModContainer container) {
        try {
            Path path = FMLPaths.CONFIGDIR.get().resolve(config.getFileName());
            CommentedFileConfig data = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().preserveInsertionOrder().autosave().onFileNotFound((file, format) -> ForgeConfigLoader.setupConfigFile(config, file, format)).writingMode(WritingMode.REPLACE).build();
            data.load();
            config.setTempConfig((CommentedConfig)data);
            container.dispatchConfigEvent(IConfigEvent.loading((ModConfig)config));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info("Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    public void onConfigReloaded(ModConfigEvent.Reloading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        ForgeConfigSpec forgeSpec = (ForgeConfigSpec)spec.self();
        ForgeResourcefulConfig config = this.configCache.get(forgeSpec);
        if (config != null) {
            this.loadConfig(config, (UnmodifiableConfig)event.getConfig().getConfigData());
        }
    }

    public void onConfigLoad(ModConfigEvent.Loading event) {
        IConfigSpec spec = event.getConfig().getSpec();
        ForgeConfigSpec forgeSpec = (ForgeConfigSpec)spec.self();
        ForgeResourcefulConfig config = this.configCache.get(forgeSpec);
        if (config != null) {
            this.loadConfig(config, (UnmodifiableConfig)event.getConfig().getConfigData());
        }
    }

    private void loadConfig(ResourcefulConfig config, UnmodifiableConfig spec) {
        String[] keys;
        Map configValues = spec.valueMap();
        for (String key : keys = spec.valueMap().keySet().toArray(new String[0])) {
            Object value = configValues.get(key);
            if (value instanceof AbstractConfig) {
                AbstractConfig subConfig = (AbstractConfig)value;
                config.getSubConfig(key).ifPresent(cat -> this.loadConfig((ResourcefulConfig)cat, (UnmodifiableConfig)subConfig));
                continue;
            }
            config.getEntry(key).ifPresent(configEntry -> {
                if (!this.setValue(value, (ResourcefulConfigEntry)configEntry)) {
                    LOGGER.error("Failed to set value for entry: {}", value);
                }
            });
        }
    }

    private boolean setValue(Object o, ResourcefulConfigEntry data) {
        if (o instanceof List) {
            List list = (List)o;
            return data.setArray(list.toArray());
        }
        if (o instanceof String) {
            String string = (String)o;
            return switch (data.type()) {
                case EntryType.STRING -> data.setString(string);
                case EntryType.ENUM -> data.setEnum(ParsingUtils.getEnum(data.field().getType(), string));
                default -> false;
            };
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            try {
                return switch (data.type()) {
                    case EntryType.BYTE -> data.setByte(number.byteValue());
                    case EntryType.SHORT -> data.setShort(number.shortValue());
                    case EntryType.INTEGER -> data.setInt(number.intValue());
                    case EntryType.LONG -> data.setLong(number.longValue());
                    case EntryType.FLOAT -> data.setFloat(number.floatValue());
                    case EntryType.DOUBLE -> data.setDouble(number.doubleValue());
                    default -> false;
                };
            }
            catch (ArithmeticException e) {
                return false;
            }
        }
        if (o instanceof Enum) {
            Enum enumValue = (Enum)o;
            return data.setEnum(enumValue);
        }
        if (o instanceof Boolean) {
            Boolean booleanValue = (Boolean)o;
            return data.setBoolean(booleanValue);
        }
        return true;
    }

    private static final class ResourcefulModConfig
    extends ModConfig {
        private CommentedConfig tempConfig;

        public ResourcefulModConfig(ModConfig.Type type, IConfigSpec<?> spec, ModContainer container, String fileName) {
            super(type, spec, container, fileName);
        }

        public void setTempConfig(CommentedConfig configData) {
            this.tempConfig = configData;
            this.getSpec().acceptConfig(configData);
        }

        public CommentedConfig getConfigData() {
            CommentedConfig config = super.getConfigData();
            return config == null ? this.tempConfig : config;
        }

        public void save() {
            ((CommentedFileConfig)this.getConfigData()).save();
        }

        public Path getFullPath() {
            return ((CommentedFileConfig)this.getConfigData()).getNioPath();
        }
    }
}

