/*
 * Decompiled with CFR 0.152.
 */
package blueduck.dustrial.dustrialdecor;

import blueduck.dustrial.dustrialdecor.config.ConfigHelper;
import blueduck.dustrial.dustrialdecor.config.DustrialDecorConfig;
import blueduck.dustrial.dustrialdecor.registry.DustrialBlocks;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dustrial_decor")
public class DustrialDecorMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static String MODID = "dustrial_decor";
    public static DustrialDecorConfig CONFIG;

    public DustrialDecorMod() {
        CONFIG = ConfigHelper.register(ModConfig.Type.COMMON, DustrialDecorConfig::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DustrialBlocks.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void entitySpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityType type;
        if (DustrialDecorMod.CONFIG.MOBS_SPAWN_WITH_CARDBOARD_ARMOR.get().booleanValue() && !event.getEntity().m_9236_().m_5776_() && event.getEntity().m_20193_().m_213780_().m_188500_() < 0.05 && ((type = event.getEntity().m_6095_()) == EntityType.f_20501_ || type == EntityType.f_20524_ || type == EntityType.f_20481_ || type == EntityType.f_20458_ || type == EntityType.f_20562_) && event.getEntity() instanceof Mob && event.getEntity().m_6844_(EquipmentSlot.HEAD).m_41619_() && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41619_() && event.getEntity().m_6844_(EquipmentSlot.LEGS).m_41619_() && event.getEntity().m_6844_(EquipmentSlot.FEET).m_41619_()) {
            Mob entity = event.getEntity();
            entity.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)DustrialBlocks.CARDBOARD_HELMET.get()));
            entity.m_21409_(EquipmentSlot.HEAD, 0.085f);
            entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)DustrialBlocks.CARDBOARD_CHESTPLATE.get()));
            entity.m_21409_(EquipmentSlot.CHEST, 0.085f);
            entity.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)DustrialBlocks.CARDBOARD_LEGGINGS.get()));
            entity.m_21409_(EquipmentSlot.LEGS, 0.085f);
            entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)DustrialBlocks.CARDBOARD_BOOTS.get()));
            entity.m_21409_(EquipmentSlot.FEET, 0.085f);
        }
    }

    public static boolean isLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Mod.EventBusSubscriber(modid="dustrial_decor")
    public static class LootEvents {
        @SubscribeEvent
        public static void onLootLoad(LootTableLoadEvent event) {
            if (DustrialDecorMod.CONFIG.LOOT_TABLE_MODIFICATION.get().booleanValue()) {
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/simple_dungeon"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/pillager_outpost"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/woodland_mansion"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/shipwreck_supply"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/stronghold_corridor"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/village/village_toolsmith"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "chests/village/village_weaponsmith"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "chests/dungeon"))).name("dustrial_inject").m_79082_());
                }
                if (event.getName().equals((Object)new ResourceLocation("minecraft", "entities/zombie"))) {
                    event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation(MODID, "entities/zombie"))).name("dustrial_inject").m_79082_());
                }
            }
        }

        @SubscribeEvent
        public static void villagerTrades(VillagerTradesEvent event) {
            if (event.getType() == VillagerProfession.f_35595_) {
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)DustrialBlocks.CINDER_BRICKS_ITEM.get(), 16), 12, 10, 0.05f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)DustrialBlocks.CINDER_BLOCK_ITEM.get(), 16), 12, 10, 0.05f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)DustrialBlocks.POLISHED_CINDER_BLOCK_ITEM.get(), 16), 12, 10, 0.05f));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="dustrial_decor", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEventBusSubscriber {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
    }
}

