/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDelay;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerActiveVariableBase;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;

public class ContainerDelay
extends ContainerActiveVariableBase<BlockEntityDelay> {
    private final int lastUpdateValueId;
    private final int lastCapacityValueId;

    public ContainerDelay(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(3), Optional.empty());
    }

    public ContainerDelay(int id, Inventory playerInventory, Container inventory, Optional<BlockEntityDelay> tileSupplier) {
        super(RegistryEntries.CONTAINER_DELAY, id, playerInventory, inventory, tileSupplier);
        this.m_38897_((Slot)new SlotVariable(inventory, 0, 81, 25));
        this.m_38897_((Slot)new SlotVariable(inventory, 1, 56, 78));
        this.m_38897_((Slot)new SlotRemoveOnly(inventory, 2, 104, 78));
        this.addPlayerInventory(playerInventory, this.offsetX + 9, this.offsetY + 145);
        this.lastUpdateValueId = this.getNextValueId();
        this.lastCapacityValueId = this.getNextValueId();
        this.getTileSupplier().ifPresent(tile -> tile.setLastPlayer(playerInventory.f_35978_));
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastUpdateValueId, (int)this.getTileSupplier().map(BlockEntityDelay::getUpdateInterval).orElse(0));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastCapacityValueId, (int)this.getTileSupplier().map(BlockEntityDelay::getCapacity).orElse(0));
    }

    public int getLastUpdateValueId() {
        return this.lastUpdateValueId;
    }

    public int getLastCapacityValueId() {
        return this.lastCapacityValueId;
    }

    public int getLastUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getLastUpdateValueId());
    }

    public int getLastCapacityValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getLastCapacityValueId());
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        this.getTileSupplier().ifPresent(tile -> {
            if (valueId == this.getLastUpdateValueId()) {
                tile.setUpdateInterval(this.getLastUpdateValue());
            } else if (valueId == this.getLastCapacityValueId()) {
                tile.setCapacity(this.getLastCapacityValue());
            }
        });
    }
}

