/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeEntity
extends ValueObjectTypeBase<ValueEntity>
implements IValueTypeNamed<ValueEntity>,
IValueTypeUniquelyNamed<ValueEntity>,
IValueTypeNullable<ValueEntity> {
    public ValueObjectTypeEntity() {
        super("entity", ValueEntity.class);
    }

    @Override
    public ValueEntity getDefault() {
        return ValueEntity.of((UUID)null);
    }

    @Override
    public MutableComponent toCompactString(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            Optional<Entity> entity = value.getRawValue();
            if (entity.isPresent()) {
                Entity e = entity.get();
                if (e instanceof ItemEntity) {
                    return (MutableComponent)((ItemEntity)e).m_32055_().m_41786_();
                }
                return (MutableComponent)e.m_7755_();
            }
            return Component.m_237113_((String)"unknown");
        }
        return Component.m_237113_((String)"");
    }

    @Override
    public Tag serialize(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            return StringTag.m_129297_((String)uuid.get().toString());
        }
        return StringTag.m_129297_((String)"");
    }

    @Override
    public ValueEntity deserialize(Tag value) {
        try {
            return ValueEntity.of(UUID.fromString(value.m_7916_()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ValueEntity.of((UUID)null);
        }
    }

    @Override
    public String getName(ValueEntity a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueEntity a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return null;
    }

    @Override
    public ValuePredicate<ValueEntity> deserializeValuePredicate(JsonObject element, @Nullable IValue value) {
        JsonElement jsonElement = element.get("entity");
        String entityTypeName = jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsString() : null;
        EntityType entityType = null;
        if (entityTypeName != null) {
            try {
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityTypeName));
            }
            catch (ResourceLocationException e) {
                throw new JsonSyntaxException("Invalid entity type name '" + entityTypeName + "'");
            }
            if (entityType == null) {
                throw new JsonSyntaxException("Could not find the entity type '" + entityTypeName + "'");
            }
        }
        return new ValueEntityPredicate(this, value, entityType);
    }

    @Override
    public String getUniqueName(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            UUID id = uuid.get();
            String entityName = value.getRawValue().map(entity -> ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString()).orElse("unknown");
            return id.toString() + " (" + entityName + ")";
        }
        return "";
    }

    public static class ValueEntity
    extends ValueBase {
        private final Optional<UUID> value;

        protected ValueEntity(@Nullable Entity value) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = value == null ? Optional.empty() : Optional.of(value.m_20148_());
        }

        private ValueEntity(@Nullable UUID entityUuid) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = Optional.ofNullable(entityUuid);
        }

        public Optional<Entity> getRawValue() {
            Optional<UUID> uuid = this.getUuid();
            if (uuid.isPresent()) {
                Optional optionalEntity = (Optional)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (MinecraftHelpers.isClientSideThread()) {
                        for (Entity entity : Minecraft.m_91087_().f_91073_.m_104735_()) {
                            if (!entity.m_20148_().equals(uuid.get())) continue;
                            return Optional.of(entity);
                        }
                        return Optional.empty();
                    }
                    return null;
                });
                if (optionalEntity == null) {
                    for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                        Entity entity = world.m_8791_(uuid.get());
                        if (entity == null) continue;
                        return Optional.of(entity);
                    }
                } else {
                    return optionalEntity;
                }
            }
            return Optional.empty();
        }

        public Optional<UUID> getUuid() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueEntity) {
                if (((ValueEntity)o).value.isPresent() && this.value.isPresent()) {
                    return ((ValueEntity)o).value.get().equals(this.value.get());
                }
                if (!((ValueEntity)o).value.isPresent() && !this.value.isPresent()) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.getRawValue().isPresent() ? this.getRawValue().get().hashCode() : 0);
        }

        public static ValueEntity of(@Nullable Entity entity) {
            return new ValueEntity(entity);
        }

        public static ValueEntity of(@Nullable UUID entityUuid) {
            return new ValueEntity(entityUuid);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeEntity.ValueEntity(value=" + String.valueOf(this.value) + ")";
        }
    }

    public static class ValueEntityPredicate
    extends ValuePredicate<ValueEntity> {
        private final EntityType<? extends Entity> entityType;

        public ValueEntityPredicate(@Nullable IValueType valueType, @Nullable IValue value, @Nullable EntityType<? extends Entity> entityType) {
            super(valueType, value);
            this.entityType = entityType;
        }

        @Override
        protected boolean testTyped(ValueEntity value) {
            return super.testTyped(value) && (this.entityType == null || value.getRawValue().isPresent() && value.getRawValue().get().m_6095_() == this.entityType);
        }
    }
}

