/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class BlockEnergyBattery
extends BlockEnergyBatteryBase {
    @Icon(location="block/energy_battery_overlay")
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite iconOverlay;

    public BlockEnergyBattery(BlockBehaviour.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack((ItemLike)this);
        int capacity = capacityOriginal = BlockEnergyBatteryConfig.capacity;
        do {
            ItemStack currentStack = itemStack.m_41777_();
            IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)((ItemBlockEnergyContainer)currentStack.m_41720_()).getEnergyBattery(currentStack).orElse(null);
            energyStorage.setCapacity(capacity);
            list.add((Object)currentStack.m_41777_());
            BlockEnergyBattery.fill(energyStorage);
            list.add((Object)currentStack.m_41777_());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(BlockEnergyBatteryConfig.maxCreativeCapacity, BlockEnergyBatteryConfig.maxCreativeTabCapacity) && capacity > lastCapacity);
    }

    @Override
    public boolean isCreative() {
        return false;
    }
}

