/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.JsonDeserializers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public class VariablePredicate<V extends IVariable> {
    private static final IVariableFacadeHandlerRegistry VARIABLE_FACADE_HANDLER_REGISTRY = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
    public static final VariablePredicate ANY = new VariablePredicate<IVariable>(IVariable.class, null, ValuePredicate.ANY);
    private final Class<V> variableClass;
    private final IValueType valueType;
    private final ValuePredicate valuePredicate;

    public VariablePredicate(Class<V> variableClass, @Nullable IValueType valueType, ValuePredicate valuePredicate) {
        this.variableClass = variableClass;
        this.valueType = valueType;
        this.valuePredicate = valuePredicate;
    }

    public final boolean test(IVariable variable) {
        try {
            return this.variableClass.isInstance(variable) && (this.valueType == null || ValueHelpers.correspondsTo(this.valueType, variable.getType())) && this.valuePredicate.test((IValue)variable.getValue()) && this.testTyped(variable);
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    protected boolean testTyped(V variable) {
        return true;
    }

    public static VariablePredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)element, (String)"variable");
            IValueType valueType = JsonDeserializers.deserializeValueType(jsonobject);
            ValuePredicate valuePredicate = JsonDeserializers.deserializeValue(jsonobject, valueType);
            JsonElement typeElement = jsonobject.get("type");
            if (typeElement != null && !typeElement.isJsonNull()) {
                String type = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type");
                IVariableFacadeHandler handler = VARIABLE_FACADE_HANDLER_REGISTRY.getHandler(new ResourceLocation(type));
                if (handler == null) {
                    throw new JsonSyntaxException("Unknown variable type '" + type + "', valid types are: " + String.valueOf(VARIABLE_FACADE_HANDLER_REGISTRY.getHandlerNames()));
                }
                return handler.deserializeVariablePredicate(jsonobject, valueType, valuePredicate);
            }
            return new VariablePredicate<IVariable>(IVariable.class, valueType, valuePredicate);
        }
        return ANY;
    }
}

