/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.api.item;

import cofh.core.item.IAugmentableItem;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public interface IContainerItem {
    default public int getMaxStored(ItemStack container, int amount) {
        int holding = Utils.getItemEnchantmentLevel(Utils.getEnchantment("cofh_core", "holding"), container);
        return Utils.getEnchantedCapacity(amount, holding);
    }

    default public boolean isCreative(ItemStack stack, ContainerType type) {
        if (stack.m_41720_() instanceof IAugmentableItem) {
            CompoundTag subTag = stack.m_41737_("Properties");
            if (subTag == null) {
                return false;
            }
            switch (type) {
                case ENERGY: {
                    return AugmentableHelper.getAttributeMod(subTag, "RFCre") > 0.0f;
                }
                case FLUID: {
                    return AugmentableHelper.getAttributeMod(subTag, "FluidCre") > 0.0f;
                }
                case ITEM: {
                    return AugmentableHelper.getAttributeMod(subTag, "ItemCre") > 0.0f;
                }
            }
        }
        return false;
    }
}

