/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.event.CoreClientSetupEvents;
import cofh.core.util.Proxy;
import cofh.lib.api.IProxyItemPropertyGetter;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class ProxyClient
extends Proxy {
    protected static final Map<ResourceLocation, Object> MODEL_MAP = new Object2ObjectOpenHashMap();
    protected static final Set<ModelPropertyWrapper> ITEM_PROPERTY_GETTERS = new HashSet<ModelPropertyWrapper>();
    protected static final Set<IAreaEffectTile> AREA_EFFECT_TILES = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void setOverlayMessage(Component message) {
        Minecraft.m_91087_().f_91065_.m_93063_(message, false);
    }

    @Override
    public void playSimpleSound(SoundEvent sound, float volume, float pitch) {
        SoundHelper.playSimpleSound(sound, volume, pitch);
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean canLocalize(String key) {
        return StringHelper.canLocalize(key);
    }

    @Override
    protected Object addModel(ResourceLocation loc, Object model) {
        return MODEL_MAP.put(loc, model);
    }

    @Override
    public Object getModel(ResourceLocation loc) {
        return MODEL_MAP.get(loc);
    }

    @Override
    public void addColorable(Item colorable) {
        CoreClientSetupEvents.addColorable(colorable);
    }

    @Override
    public void registerItemModelProperty(Item item, ResourceLocation resourceLoc, IProxyItemPropertyGetter propertyGetter) {
        ITEM_PROPERTY_GETTERS.add(new ModelPropertyWrapper(item, resourceLoc, propertyGetter));
    }

    @Override
    public void addAreaEffectTile(IAreaEffectTile tile) {
        AREA_EFFECT_TILES.add(tile);
    }

    @Override
    public void removeAreaEffectTile(IAreaEffectTile tile) {
        AREA_EFFECT_TILES.remove(tile);
    }

    public static Set<IAreaEffectTile> getAreaEffectTiles() {
        return AREA_EFFECT_TILES;
    }

    public static void registerItemModelProperties() {
        for (ModelPropertyWrapper wrapper : ITEM_PROPERTY_GETTERS) {
            ItemProperties.register((Item)wrapper.item, (ResourceLocation)wrapper.resourceLoc, (ItemPropertyFunction)wrapper.propertyGetter);
        }
        ITEM_PROPERTY_GETTERS.clear();
    }

    protected static class ModelPropertyWrapper {
        Item item;
        ResourceLocation resourceLoc;
        ItemPropertyFunction propertyGetter;

        ModelPropertyWrapper(Item item, ResourceLocation resourceLoc, IProxyItemPropertyGetter propertyGetter) {
            this.item = item;
            this.resourceLoc = resourceLoc;
            this.propertyGetter = propertyGetter::call;
        }
    }
}

