/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectAddedPacket
extends PacketBase
implements IPacketClient {
    protected LivingEntity entity;
    protected MobEffectInstance effect;

    public EffectAddedPacket() {
        super(96, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        if (this.entity != null && this.effect != null && !this.entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.entity.m_147215_(this.effect, null);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entity.m_19879_());
        buf.m_130085_(Utils.getRegistryName(this.effect.m_19544_()));
        buf.writeInt(this.effect.m_19557_());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        Player client = ProxyUtils.getClientPlayer();
        if (client == null) {
            return;
        }
        Entity entity = client.f_19853_.m_6815_(buf.readInt());
        MobEffect effectType = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buf.m_130281_());
        if (entity instanceof LivingEntity && effectType != null) {
            this.entity = (LivingEntity)entity;
            this.effect = new MobEffectInstance(effectType, buf.readInt());
        }
    }

    public static void sendToClient(LivingEntity entity, MobEffectInstance effect) {
        if (!entity.f_19853_.f_46443_) {
            EffectAddedPacket packet = new EffectAddedPacket();
            packet.entity = entity;
            packet.effect = effect;
            packet.sendToAllAround(entity.m_20182_(), 192.0, (ResourceKey<Level>)entity.f_19853_.m_46472_());
        }
    }
}

