/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.SpriteParticle;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.Color;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class GasParticle
extends SpriteParticle {
    protected Color baseColor;
    protected float groundFriction = 0.5f;

    protected GasParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z, dx, dy, dz);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        this.baseColor = Color.fromRGBA(data.rgba0);
    }

    @Override
    public void m_5989_() {
        if ((float)this.f_107224_ > this.delay) {
            int max = MathHelper.ceil(this.duration * 128.0f);
            int time = MathHelper.clamp(MathHelper.floor(((float)this.f_107224_ - this.delay) * 128.0f), 0, max);
            this.sprite = this.sprites.m_5819_(time, max);
            super.m_5989_();
        } else {
            ++this.f_107224_;
        }
    }

    public void m_6257_(double dx, double dy, double dz) {
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        Vec3 start = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 velocity = new Vec3(dx, dy, dz);
        Vec3 end = start.m_82520_(dx, dy, dz);
        if (this.f_107219_) {
            BlockHitResult result = this.f_107208_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
            if (!this.f_107208_.m_6425_(result.m_82425_()).m_76178_()) {
                this.m_107274_();
                return;
            }
            if (result.m_6662_() != HitResult.Type.MISS) {
                Vec3 loc = result.m_82450_();
                Vec3 remaining = end.m_82546_(loc).m_82490_((double)this.groundFriction);
                Direction face = result.m_82434_();
                Direction.Axis axis = face.m_122434_();
                velocity = velocity.m_193103_(axis, 0.0).m_82490_((double)0.3f);
                end = loc.m_82549_(remaining.m_193103_(axis, (double)((float)face.m_122421_().m_122540_() * 0.05f)));
            }
        }
        if (!(end = end.m_82546_(start)).equals((Object)Vec3.f_82478_)) {
            this.m_107259_(this.m_107277_().m_82383_(end));
            this.m_107275_();
        }
        this.f_107215_ = velocity.f_82479_;
        this.f_107216_ = velocity.f_82480_;
        this.f_107217_ = velocity.f_82481_;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_OVER;
    }
}

